<?php


$args = [
    'number' => 10,
    'orderby' => 'name',
    'order' => 'ASC',
    'post_type' => 'specialists',
    'post_status' => 'publish',
    'suppress_filters' => true,
];


$posts = get_posts($args);

if ($posts) : ?>
    <section id="specialists" class="w-100 px-0 my-5 bg-gray-25" data-aos="fadeIn" data-aos-delay="200">
        <div class="container">
            <div class="row">
                <div class="py-4">
                    <h2 class="section-title mx-auto fst-italic fw-light"><?= pll_e('specialists'); ?></h2>
                </div>
                <?php foreach ($posts as $post) : setup_postdata($post); ?>
                    <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                        <div class="specialist">
                            <div class="img-box">
                                <?php the_post_thumbnail('',['class'=>'img-fluid']); ?>
                            </div>
                            <div class="mt-4">
                                <span class="h5 fw-bolder"><?php the_title(); ?></span>
                                <p class="mt-2"><?php the_content(); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
<?php endif; ?>