<?php wp_footer(); ?>

<footer class="text-center text-lg-start bg-light text-muted mt-5">
    <section class="d-flex justify-content-center justify-content-lg-between p-4 border-bottom">
        <div class="social-links mx-auto">
            <?php
            $accounts = get_social_media_accounts();

            foreach ($accounts as $account) : ?>
                <a href="<?= $account['link']; ?>" class="me-4 text-reset" title="<?= $title; ?>">
                    <span class="fa-stack fa-2x">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="<?= $account['icon']; ?> fa-stack-1x fa-inverse"></i>
                    </span>
                </a>
            <?php endforeach; ?>
        </div>
    </section>
    <section class="">
        <div class="container text-center text-md-start mt-5">
            <div class="row mt-3">
                <?php 
                    if (is_active_sidebar('footer_col_1')) : 
                        dynamic_sidebar('footer_col_1');
                    endif;
                ?>
                <?php 
                    if (is_active_sidebar('footer_col_2')) : 
                        dynamic_sidebar('footer_col_2');
                    endif;
                ?>

                <?php

                $branches = get_branches();

                if ($branches) :
                    foreach ($branches as $branch) : ?>
                        <div class="col-md-3 col-lg-2 col-xl-2 mx-auto mb-4">
                            <h6 class="text-uppercase fw-bold mb-4">
                                <?= $branch['name']; ?>
                            </h6>
                            <p>
                                <i class="fas fa-home me-3"></i>
                                <?= $branch['address']; ?>
                            </p>
                            <?php if ($branch['phone']) : ?>
                                <p>
                                    <i class="fas fa-phone me-3"></i>
                                    <?= $branch['phone']; ?>
                                </p>
                            <?php endif; ?>
                            <?php if ($branch['mobile']) : ?>
                                <p>
                                    <i class="fas fa-mobile me-3"></i>
                                    <?= $branch['mobile']; ?>
                                </p>
                            <?php endif; ?>
                            <p>
                                <i class="fas fa-calendar me-3"></i>
                                <?= $branch['days']; ?>
                            </p>
                            <p>
                                <i class="fas fa-clock me-3"></i>
                                <?= $branch['start_time']; ?> - <?= $branch['end_time']; ?>
                            </p>
                        </div>
                <?php
                    endforeach;
                endif;
                ?>
            </div>

        </div>
    </section>

    <?php

    get_branches();

    ?>
    <div class="d-flex w-100" style="background-color: rgba(0, 0, 0, 0.05);">
        <div class="text-start p-4" >
            <?= pll_e('copyrights'); ?> <a class="text-reset fw-bold" href="https://zain-clinic.com/">Zain Clinic</a> &copy; 2021 - <?= date('Y'); ?> 
        </div>
        <div class="text-end p-4 ms-auto">
            <?= pll_e('designed_by'); ?> <a href="https://auxiliumps.com" class="text-reset">Au<b class="text-info">X</b>ilium Technology</a> 
        </div>
    </div>
</footer>
<script>
    jQuery(function($) {
        AOS.init({
            once: true,
            duration: 1000
        });

        /* Init tooltip */
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        })
    });
</script>

</body>

</html>