<?php

get_header();

$clinic = get_queried_object();

?>

<div class="container-fluid mb-5">
    <div class="row bg-gray-25">
        <section id="page-title" class="col-12 rounded-4 pt-3">
            <h1 class="text-center"><?= $clinic->name; ?></h1>
            <div class="d-flex">
                <?php if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs" class="mx-auto">', '</p>');
                } ?>
            </div>
        </section>
    </div>
</div>
<div id="tax-clinic-treatments" class="container py-5">
    <?php

    $pll_category = pll_get_term($clinic->term_id);

    $args = [
        'posts_per_page' => get_option( 'posts_per_page' ),
        'orderby' => 'name',
        'order' => 'ASC',
        'post_type' => 'clinic_treatments',
        'post_status' => 'publish',
        'suppress_filters' => true,
        'paged' => (get_query_var('paged')) ? get_query_var('paged') : 1,
        'tax_query' => array(
            array(
                'taxonomy' => 'zain_clinics',
                'field' => 'term_id',
                'terms' => $pll_category
            )
        ),
    ];

    $clinic_treatments = new WP_Query($args);

    if ($clinic_treatments->have_posts()) : ?>
        <div class="row">
            <?php while ($clinic_treatments->have_posts()) : $clinic_treatments->the_post(); ?>
                <div class="col-6 col-lg-4 col-xxl-3 mb-3 d-flex align-items-stretch">
                    <div class="card w-100 d-flex">
                        <a href="<?php the_permalink(); ?>" class="text-center h-100 bg-gray-25 py-3">
                            <?php the_post_thumbnail('',['class' => 'img-fluid opacity-75']); ?>
                        </a>
                        <div class="card-body d-flex flex-column text-start mt-4">
                            <h5 class="card-title text-center mb-4"><?php the_title(); ?></h5>
                            <p class="card-text font-sm fw-normal">
                                <?= excerpt(20); ?>
                            </p>
                            <a href="<?php the_permalink(); ?>" class="btn btn-outline-gold mt-auto"><?= pll_e('view_details'); ?></a>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
        <div class="row">
            <div class="col-auto mx-auto mt-4">
                <?php bootstrap_pagination($clinic_treatments); ;?>
            </div>
        </div>
    <?php endif; ?>
<?php wp_reset_postdata(); ?>
</div>
<?php get_footer(); ?>