<?php

// Get posts for each treatment_category

$args = [
    'number' => 10,
    'orderby' => 'sort_order',
    'order' => 'ASC',
    'post_type' => 'testimonials',
    'post_status' => 'publish',
    'suppress_filters' => true,
];

$posts = get_posts($args);

if ($posts) : ?>
    <section id="testimonials" class="w-100 px-0 my-5">
        <div class="container">
            <div class="row">
                <div class="py-4">
                    <h2 class="section-title mx-auto fst-italic fw-light" data-aos="fadeIn" data-aos-delay="200"><?= pll_e('testimonials'); ?></h2>
                </div>
                <div class="col-12">
                    <div class="swiper h-100">
                        <div class="swiper-wrapper d-flex h-100 align-items-stretch">
                            <?php foreach ($posts as $post) : setup_postdata($post); ?>
                                <div class="swiper-slide p-5 h-100">
                                    <div class="card w-100 border-gold-light shadow py-4 h-100">
                                        <?php the_post_thumbnail('', ['class' => 'author-img mx-auto img-fluid rounded-circle card-img-top']); ?>
                                        <div class="card-body">
                                            <h4 class="card-title text-center mb-4">
                                                <?php the_title(); ?>
                                            </h4>
                                            <p class="card-text">
                                                <i class="fas fa-quote-left text-gold" aria-hidden="true"></i>
                                                <?php the_content(); ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                </div>
            </div>
            <script>
                jQuery(function($) {
                    var swiper = new Swiper("#testimonials .swiper", {
                        slidesPerView: 1,
                        spaceBetween: 10,
                        loop: true,
                        navigation: {
                            nextEl: ".swiper-button-next",
                            prevEl: ".swiper-button-prev",
                        },
                        breakpoints: {
                            640: {
                                slidesPerView: 1,
                                spaceBetween: 10,
                            },
                            992: {
                                slidesPerView: 2,
                                spaceBetween: 30,
                            },
                            1400: {
                                slidesPerView: 3,
                                spaceBetween: 10,
                            },
                        },
                    });
                });
            </script>
    </section>
<?php endif; ?>