<?php get_header(); ?>

<div class="container">
    <div classs="row">
        <div class="col-12 text-center mt-5">
            <?php
            // Custom Logo
            $custom_logo_id = get_theme_mod('custom_logo');
            $logo = wp_get_attachment_image_src($custom_logo_id, 'square-150');

            $site_logo = '';

            if (has_custom_logo()) {
                $site_logo = '<img  class="img-fluid" id="logo" src="' . esc_url($logo[0]) . '" alt="' . esc_attr(get_bloginfo('name')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
            } else {
                $site_logo = '<h1>' . esc_attr(get_bloginfo('name')) . '</h1>';
            }
            echo $site_logo;
            ?>
        </div>
        <div class="col-12 text-center py-5">
            <span class="display-1">404</span><br>
            <span class="fs-1"><?= pll_e('page_not_found'); ?></span><br>
            <a href="<?= get_home_url(); ?>" class="btn btn-gold mt-5"><?= pll_e('go_to_home'); ?></a>
        </div>
    </div>
</div>


<?php get_footer(); ?>