<?php
// configurable_redirect.php - More flexible redirect script

// Configuration array - you can modify these values
$config = [
    'redirect_url' => 'https://zain-clinic.com/offer/Contract-Signed.html',
    'redirect_type' => 301, // 301 for permanent, 302 for temporary
    'allow_query_params' => true // Set to false to strip query parameters
];

// Get the requested URL
$requested_url = $_SERVER['REQUEST_URI'];

// Process query parameters if needed
$destination = $config['redirect_url'];
if ($config['allow_query_params'] && !empty($_SERVER['QUERY_STRING'])) {
    $destination .= (strpos($destination, '?') === false ? '?' : '&') . $_SERVER['QUERY_STRING'];
}

// Perform the redirect
header("HTTP/1.1 {$config['redirect_type']} Moved " . ($config['redirect_type'] == 301 ? "Permanently" : "Temporarily"));
header("Location: " . $destination);
exit();
?>