<?php

namespace App\Exports;

use App\Models\Patient;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExportPatient implements FromCollection, WithHeadings
{

    /**
     * @return \Illuminate\Support\Collection
     */
    public function headings(): array
    {
        return [
            '#',
            __('admin/patients.columns.patient_name'),
            __('admin/patients.columns.dob'),
            __('admin/patients.columns.mobile'),
            __('admin/patients.columns.gender'),
            __('admin/patients.columns.region'),
        ];
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        // Prep the model
        $model = new Patient();

        $model = $model->join('regions', 'regions.id', '=', 'patients.region_id');

        $model = $model->allowedPatients();

        // Concatenating name columns
        $full_name = DB::raw("CONCAT(COALESCE(patients.first_name,''),' ',COALESCE(patients.second_name,''),' ',COALESCE(patients.third_name,''),' ',COALESCE(patients.last_name,'')) AS patient_name");

        // Changing m and f to Male & Female
        $male = __('admin/common.gender.male');
        $female = __('admin/common.gender.female');

        $gender = DB::raw("IF(gender='m','" . $male . "', '" . $female . "') AS gender");

        // Setting the parameters
        $select = ['patients.id', $full_name,'dob','mobile', $gender, 'regions.region as region'];

        $model = $model->select($select);

        return $model->get();
    }
}
