<?php

namespace App\Http\Controllers\Admin;

use App\Models\Notification;
use Diglactic\Breadcrumbs\Breadcrumbs;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    /**
     * Render the controller view into the app layout
     *
     * @param string $page
     * @param string $title_lang_key
     * @param string $breadcrumb_name Breadcrumb key string in routes/breadcrumb
     * @param array $breadcrumb_data
     * @param array $data
     * @return void
     */
    protected function loadView($page, $title_lang_key,$breadcrumb_name,$breadcrumb_data = null, $data = [], $css = [], $js = [] ){

        // prep.  data

		$data['_page_title'] = __('admin/'.$title_lang_key);

		// breadcrubms

        if ( !empty($breadcrumb_data) ){
            $data['_breadcrumbs'] = Breadcrumbs::render('admin.'.$breadcrumb_name,$breadcrumb_data);
        
        }else{

            $data['_breadcrumbs'] = Breadcrumbs::render('admin.'.$breadcrumb_name);
        }

        $data['_page'] = 'admin.'.$page;
		
        $data['_css'] = $css;
        $data['_js'] = $js;

        // get user notifications

        $data['_notifications'] =  user_notifications();
        $data['_notifications_count'] =  user_notifications_count();

   

        echo view('admin.app.app',$data);
    }
}
