<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\Controller;
use App\Libraries\Tabler;
use App\Models\Region;
use App\Rules\ArEnAlphaNumSpace;
use App\Rules\GeneralText;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class RegionsController extends Controller
{
    public function index(Request $request){
        
        $th_columns = ['region'];
        $select_columns = ['id','region'];
        $sortable_columns = ['region'];
        $searchable_columns = ['region'];
      
        $model = new Region();

        $route_key = 'admin.regions';

        $table = new Tabler($route_key, $model, $select_columns, $th_columns, $sortable_columns, $searchable_columns, $request);

        $data = $table->initTable();

        
        $this->loadView('regions.index','regions.title','regions',[],$data);

    }

    public function add(Request $request){
        
        if ( $request->method() == 'POST'){
            
            $validated = $request->validate([
                'region' => ['required','unique:regions,region','min:2','max:200', new ArEnAlphaNumSpace],
            ]);

            /*****************************************************************
             *  When validation failes, Laravel automatically exits the code
             * ***************************************************************/ 
            
            Region::create($validated);
            
            return redirect()->route('admin.regions')->with('success', __('admin/common.msgs.success.add'));
            
        }


        $this->loadView('regions.add','regions.add_title','regions.add');
    }

    public function edit(Request $request, Region $region){

        if ( $request->method() == 'POST'){

            $validated = $request->validate([
                'region' => ['required',Rule::unique('regions','region')->ignore($region->id),'min:2','max:200', new ArEnAlphaNumSpace],
            ]);

            /*****************************************************************
             *  When validation failes, Laravel automatically exits the code
             * ***************************************************************/ 
            Region::where('id',$region->id)->update($validated);
            
            return redirect()->route('admin.regions')->with('success', __('admin/common.msgs.success.edit'));
            
        }
       

        $this->loadView('regions.edit','regions.edit_title','regions.edit',$region,$region->toArray());

    }

    public function delete(Request $request, Region $region){

        
        if ( $region->branches && $region->branches->count() > 0 ){
            
            return redirect()->route('admin.regions')->with('danger', __('admin/common.msgs.error.delete'));

        }

        if ( $region->patients && $region->patients->count() > 0){

            return redirect()->route('admin.regions')->with('danger', __('admin/common.msgs.error.delete'));

        }

        $region->delete();

        return redirect()->route('admin.regions')->with('success', __('admin/common.msgs.success.delete') );
    }

}
