<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PatientComment extends Model
{
    use HasFactory;

    protected $fillable = ['patient_id', 'added_by', 'comment'];


    
    /**
     * Scope a query to filter by allowed patients only
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeFiltered($query)
    {

        return (!is_admin() ) ? $query->whereIn('patient_id', allowed_patients()) : $query;
        
    }


    /*============*
     * Relations
     *============*/
    public function patient(){

        return $this->belongsTo(Patient::class);
        
    }
    //-------------------------------
    public function user(){

        return $this->belongsTo(User::class,'added_by');
        
    }

    /*============*
     * Attributes
     *============*/
    public function getCommentTimeAttribute(){

        return date('D, Y-m-d @ h:i:s A', strtotime($this->created_at));

    }
}
