<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserActivityLog extends Model
{
    use HasFactory;

    protected $fillable = ['route','user_id','function','request_method'];


    /**
     * Scope a query to filter by allowed users only
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeAllowedUsers($query)
    {
        return (!is_admin() && user_role() ) ? $query->whereIn('user_activity_logs.id', allowed_users()) : $query;
    }

    /**
     * User Details
     *
     * @return Illuminate\Database\Eloquent\Concerns\HasRelationships::belongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

}
