<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'The :attribute must be accepted.',
    'accepted_if' => 'The :attribute must be accepted when :other is :value.',
    'active_url' => 'The :attribute is not a valid URL.',
    'after' => 'The :attribute must be a date after :date.',
    'after_or_equal' => 'The :attribute must be a date after or equal to :date.',
    'alpha' => 'The :attribute must only contain letters.',
    'alpha_dash' => 'The :attribute must only contain letters, numbers, dashes and underscores.',
    'alpha_num' => 'The :attribute must only contain letters and numbers.',
    'array' => 'The :attribute must be an array.',
    'before' => 'The :attribute must be a date before :date.',
    'before_or_equal' => 'The :attribute must be a date before or equal to :date.',
    'between' => [
        'numeric' => 'The :attribute must be between :min and :max.',
        'file' => 'The :attribute must be between :min and :max kilobytes.',
        'string' => 'The :attribute must be between :min and :max characters.',
        'array' => 'The :attribute must have between :min and :max items.',
    ],
    'boolean' => 'The :attribute field must be true or false.',
    'confirmed' => 'The :attribute confirmation does not match.',
    'current_password' => 'The password is incorrect.',
    'date' => 'The :attribute is not a valid date.',
    'date_equals' => 'The :attribute must be a date equal to :date.',
    'date_format' => 'The :attribute does not match the format :format.',
    'different' => 'The :attribute and :other must be different.',
    'digits' => 'The :attribute must be :digits digits.',
    'digits_between' => 'The :attribute must be between :min and :max digits.',
    'dimensions' => 'The :attribute has invalid image dimensions.',
    'distinct' => 'The :attribute field has a duplicate value.',
    'email' => 'The :attribute must be a valid email address.',
    'ends_with' => 'The :attribute must end with one of the following: :values.',
    'exists' => 'The selected :attribute is invalid.',
    'file' => 'The :attribute must be a file.',
    'filled' => 'The :attribute field must have a value.',
    'gt' => [
        'numeric' => 'The :attribute must be greater than :value.',
        'file' => 'The :attribute must be greater than :value kilobytes.',
        'string' => 'The :attribute must be greater than :value characters.',
        'array' => 'The :attribute must have more than :value items.',
    ],
    'gte' => [
        'numeric' => 'The :attribute must be greater than or equal :value.',
        'file' => 'The :attribute must be greater than or equal :value kilobytes.',
        'string' => 'The :attribute must be greater than or equal :value characters.',
        'array' => 'The :attribute must have :value items or more.',
    ],
    'image' => 'The :attribute must be an image.',
    'in' => 'The selected :attribute is invalid.',
    'in_array' => 'The :attribute field does not exist in :other.',
    'integer' => 'The :attribute must be an integer.',
    'ip' => 'The :attribute must be a valid IP address.',
    'ipv4' => 'The :attribute must be a valid IPv4 address.',
    'ipv6' => 'The :attribute must be a valid IPv6 address.',
    'json' => 'The :attribute must be a valid JSON string.',
    'lt' => [
        'numeric' => 'The :attribute must be less than :value.',
        'file' => 'The :attribute must be less than :value kilobytes.',
        'string' => 'The :attribute must be less than :value characters.',
        'array' => 'The :attribute must have less than :value items.',
    ],
    'lte' => [
        'numeric' => 'The :attribute must be less than or equal :value.',
        'file' => 'The :attribute must be less than or equal :value kilobytes.',
        'string' => 'The :attribute must be less than or equal :value characters.',
        'array' => 'The :attribute must not have more than :value items.',
    ],
    'max' => [
        'numeric' => 'The :attribute must not be greater than :max.',
        'file' => 'The :attribute must not be greater than :max kilobytes.',
        'string' => 'The :attribute must not be greater than :max characters.',
        'array' => 'The :attribute must not have more than :max items.',
    ],
    'mimes' => 'The :attribute must be a file of type: :values.',
    'mimetypes' => 'The :attribute must be a file of type: :values.',
    'min' => [
        'numeric' => 'The :attribute must be at least :min.',
        'file' => 'The :attribute must be at least :min kilobytes.',
        'string' => 'The :attribute must be at least :min characters.',
        'array' => 'The :attribute must have at least :min items.',
    ],
    'multiple_of' => 'The :attribute must be a multiple of :value.',
    'not_in' => 'The selected :attribute is invalid.',
    'not_regex' => 'The :attribute format is invalid.',
    'numeric' => 'The :attribute must be a number.',
    'password' => 'The password is incorrect.',
    'present' => 'The :attribute field must be present.',
    'regex' => 'The :attribute format is invalid.',
    'required' => 'The :attribute field is required.',
    'required_if' => 'The :attribute field is required when :other is :value.',
    'required_unless' => 'The :attribute field is required unless :other is in :values.',
    'required_with' => 'The :attribute field is required when :values is present.',
    'required_with_all' => 'The :attribute field is required when :values are present.',
    'required_without' => 'The :attribute field is required when :values is not present.',
    'required_without_all' => 'The :attribute field is required when none of :values are present.',
    'prohibited' => 'The :attribute field is prohibited.',
    'prohibited_if' => 'The :attribute field is prohibited when :other is :value.',
    'prohibited_unless' => 'The :attribute field is prohibited unless :other is in :values.',
    'same' => 'The :attribute and :other must match.',
    'size' => [
        'numeric' => 'The :attribute must be :size.',
        'file' => 'The :attribute must be :size kilobytes.',
        'string' => 'The :attribute must be :size characters.',
        'array' => 'The :attribute must contain :size items.',
    ],
    'starts_with' => 'The :attribute must start with one of the following: :values.',
    'string' => 'The :attribute must be a string.',
    'timezone' => 'The :attribute must be a valid timezone.',
    'unique' => 'The :attribute has already been taken.',
    'uploaded' => 'The :attribute failed to upload.',
    'url' => 'The :attribute must be a valid URL.',
    'uuid' => 'The :attribute must be a valid UUID.',


    // Custom rules 
    'alpha_space' => 'The :attribute may only contain arabic letters, english letters, and spaces.',
    'mobile' => 'Please check the :attribute field.',
    'phone' => 'Please check the :attribute field.',
    'general_text' => 'The :attribute field may only contain letters, number, spaces, dashes, underscores, and periods.',
    'ar_en_alpha_num_space' => 'The :attribute field may only contain arabic letters, english letters, numbers, and spaces.',
    'ar_alpha_space' => 'The :attribute field may only contain arabic letters, and spaces.',
    'ar_alpha_numeric_space' => 'The :attribute field may only contain arabic letters, numbers, and spaces.',
    'ar_alpha_numeric_space_dash' => 'The :attribute field may only contain arabic letters, numbers, dashes, undescores, and spaces.',
    'ar_general' => 'The :attribute field may only contain arabic letters, number, spaces, dashes, underscores, and periods.',
    'en_alpha_space_dash' => 'The :attribute field may only contain letters, spaces, and dashes',



    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    /* 'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ], */

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'address' => 'Address',
        'ap-date' => 'Appointment Date',
        'ap-session' => 'Appointment Time',
        'attachment' => 'Attachment',
        'attachment-title' => 'Attachment Title',
        'patient-attachment' => 'Attachment',
        'branch' => 'Branch',
        'branches' => 'Branch',
        'category' => 'Category Name',
        'comment' => 'Comment',
        'complaint-date' => 'Complaint Date',
        'conflict-treatments' => 'Conflicts',
        'cpassword' => 'Confirm Password',
        'description' => 'Description',
        'dob' => 'Date of birth',
        'email' => 'Email',
        'end_time' => 'End Time',
        'first-name' => 'First Name',
        'is-physician' => 'Physician Role',
        'last-name' => 'Last Name',
        'message' => 'Message',
        'min-sessions' => 'Minimum sessions',
        'mobile' => 'Mobile Number',
        'name' => 'Name',
        'patient' => 'Patient',
        'password' => 'Password',
        'phone' => 'Phone',
        'pretests' => 'Pretests',
        'price' => 'Price',
        'treatment-prices' => 'Price',
        'region' => 'Region',
        'role' => 'Role Name',
        'second-name' => 'Second Name',
        'session' => 'Session',
        'session-date' => 'Session Date',
        'session-number' => 'Session Number',
        'session-type' => 'Session Type',
        'session-rooms' => 'Session rooms or devices',
        'start_time' => 'Start Time',
        'third-name' => 'Third Name',
        'treatment' => 'Treatment',
        'treatment-devices' => 'Devices',
        'q1' => 'Question 1',
        'q2' => 'Question 2',
        'q3' => 'Question 3',
        'q4' => 'Question 4',
        'q5' => 'Question 5',
        'q6' => 'Question 6',
        'q7' => 'Question 7',
        'q8' => 'Question 8',
        'q9' => 'Question 9',
        'q10' => 'Question 10',
        'q11' => 'Question 11',
        'q12' => 'Question 12',
        'q13' => 'Question 13',
        'q14' => 'Question 14',
        'q1-input' => 'Question 1 description',
        'q2-input' => 'Question 2 description',
        'q3-input' => 'Question 3 description',
        'q4-input' => 'Question 4 description',
        'q5-input' => 'Question 5 description',
        'q6-input' => 'Question 6 description',
        'q7-input' => 'Question 7 description',
        'q8-input' => 'Question 8 description',
        'q9-input' => 'Question 9 description',
        'q10-input' => 'Question 10 description',
        'q11-input' => 'Question 11 description',
        'q12-input' => 'Question 12 description',
        'q13-input' => 'Question 13 description',
        'q14-input' => 'Question 14 description',
        'session-number' => 'Session Number',
        'session-date' => 'Session Date',
        'session-type' => 'Session Type',



        'body-spot-size' => 'Spot size for body',
        'body-pulse' => 'Pulse for body',
        'body-e' => 'E for body',
        'body-hair' => 'Hair for body',
        'face-spot-size' => 'Spot size for face',
        'face-pulse' => 'Pulse for face',
        'face-e' => 'E for face',
        'face-hair' => 'Hair for face',
        'sens-spot-size' => 'Spot size for sensitive area',
        'sens-pulse' => 'Pulse for sensitive area',
        'sens-e' => 'E for sensitive area',
        'sens-hair' => 'Hair for sensitive area',
    ],

];
