<div class="col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.offers.update', $offer) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-title" class="col-form-label required">
                        {{ __('admin/offers.form.title') }}
                    </label>
                    <input type="text" name="title" class="form-control" id="add-title"
                        value="{{ old('title', $offer->title) }}">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-description" class="col-form-label">
                        {{ __('admin/offers.form.description') }}
                    </label>
                    <textarea name="description" class="form-control"
                        rows="5">{{ old('description', $offer->description) }}</textarea>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-3">
                    <label for="add-start-date"
                        class="col-form-label required">{{ __('admin/offers.form.start_date') }}</label>
                    <div class="input-group date" id="add-start-date" data-target-input="nearest">
                        <input type="text" name="start-date" class="form-control datetimepicker-input"
                            data-target="#add-start-date" value="{{ old('start-date', $offer->start_date) }}">
                        <div class="input-group-append" data-target="#add-start-date" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-lg-3">
                    <label for="add-end-date"
                        class="col-form-label required">{{ __('admin/offers.form.end_date') }}</label>
                    <div class="input-group date" id="add-end-date" data-target-input="nearest">
                        <input type="text" name="end-date" class="form-control datetimepicker-input"
                            data-target="#add-end-date" value="{{ old('end-date', $offer->end_date) }}">
                        <div class="input-group-append" data-target="#add-end-date" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-image" class="col-form-label required">
                        {{ __('admin/offers.form.image') }}
                    </label>
                    @if ($offer->image)
                        <div class="card elevation-0">
                            <div class="card-body">
                                <img id="offer-img" src="{{ url(config('admin.public_uploads_dir') . '/' . $offer->image) }}"
                                    style="max-width:300px">
                            </div>
                            <div class="card-footer">
                                <button id="remove-image" class="btn btn-danger btn-sm" type="button">
                                    <i class="fas fa-times"></i>
                                    {{ __('admin/common.buttons.delete') }}
                                </button>
                                <input name="no-image" type="hidden" id="no-image" value="{{ $offer->image }}">
                            </div>
                        </div>
                    @endif
                    <div class="input-group">
                        <div class="custom-file">
                            <input type="file" name="image" class="custom-file-input" id="offer-image"
                                aria-describedby="offer-image">
                            <label class="custom-file-label" for="offer-image">
                                {{ __('admin/common.buttons.browse') }}
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <x-admin.form.save-button title="{{ __('admin/common.btn.save') }}" />
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {

            let end_date = moment().add(1, "months").format("YYYY-MM-DD");
            let start_date = moment().format("YYYY-MM-DD");

            $('#add-start-date').datepicker({
                format: 'yyyy-mm-dd',
                endDate: end_date,
                startDate: '0d',
            });

            end_date = moment().add(6, "months").format("YYYY-MM-DD");

            $('#add-end-date').datepicker({
                format: 'yyyy-mm-dd',
                endDate: end_date,
                startDate: '+1d',
            });


            $('#remove-image').on('click', function() {
                $('#offer-img').attr("src", "");
                $('#no-image').val("");
            });

        });
    </script>
</div>
