<div id="patient-info" class="col-12">
    <div class="card w-100 elevation-0 border-0">
        <div class="card-header bg-primary border-0">
            <h3 class="card-title">{{ $patient->full_name }}</h3>
            <div class="card-tools">
                <button type="button" class="btn btn-tool text-white" data-card-widget="collapse"><i class="fas fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-12 col-lg-6 col-xl-4 mb-2">
                    <label class="font-weight-bold">{{ __('admin/patients_info.fields.dob') }}:</label>
                    <label class="ml-2">{{ $patient->formatted_dob }}</label>
                </div>
                <div class="ccol-12 col-lg-6 col-xl-4 mb-3">
                    <label class="font-weight-bold">{{ __('admin/patients_info.fields.age') }}:</label>
                    <label class="ml-2">{{ $patient->age }}</label>
                </div>
                <div class="col-12 col-lg-6 col-xl-4 mb-3">
                    <label class="font-weight-bold">{{ __('admin/patients_info.fields.gender') }}:</label>
                    <label class="ml-2">{{ $patient->full_gender }}</label>
                </div>
                <div class="col-12 col-lg-6 col-xl-4 mb-3">
                    <label class="font-weight-bold">{{ __('admin/patients_info.fields.region') }}:</label>
                    <label class="ml-2">{{ $patient->region->region }}</label>
                </div>
                <div class="col-12 col-lg-6 col-xl-4 mb-3">
                    <label class="font-weight-bold">{{ __('admin/patients_info.fields.address') }}:</label>
                    <label class="ml-2">{{ $patient->address }}</label>
                </div>
                <div class="col-12 col-lg-6 col-xl-4 mb-3">
                    <label class="font-weight-bold">{{ __('admin/patients_info.fields.mobile') }}:</label>
                    <label class="ml-2">{{ $patient->mobile }}</label>
                </div>
                <div class="col-12 col-lg-6 col-xl-4 mb-3">
                    <label class="font-weight-bold">{{ __('admin/patients_info.fields.email') }}:</label>
                    <label class="ml-2">{{ $patient->email }}</label>
                </div>
                <div class="col-12 col-lg-6 col-xl-4 mb-3">
                    <label class="font-weight-bold">{{ __('admin/patients_info.fields.comments') }}:</label>
                    <label class="ml-2">{{ $patient->comment }}</label>
                </div>
            </div>
        </div>
    </div>
    <div class="w-100 bg-white p-3 border-bottom">
        <ul class="list-inline mb-0 d-flex justify-content-between patient-info-tabs py-3 border-bottom mb-3">
            <li class="list-inline-item @if ($tab_content_page == 'comments') active @endif">
                <a href="{{ route('admin.patients.info.comments',$patient->id) }}" title="{{ __('admin/patients_info.nav.hint_comments')}}">
                    <i class="fas fa-info"></i>
                    <span class="d-none d-lg-inline-block">{{ __('admin/patients_info.nav.comments')}}</span>
                </a>
            </li>
            <li class="list-inline-item @if ($tab_content_page == 'appointments') active @endif">
                <a href="{{ route('admin.patients.info.appointments',$patient->id) }}" title="{{ __('admin/patients_info.nav.hint_appointments')}}">
                    <i class="fas fa-calendar-alt"></i>
                    <span class="d-none d-lg-inline-block">{{ __('admin/patients_info.nav.appointments')}}</span>
                </a>
            </li>
            <li class="list-inline-item @if ($tab_content_page == 'pretests') active @endif">
                <a href="{{ route('admin.patients.info.pretests',$patient->id) }}" title="{{ __('admin/patients_info.fields.hint_pretests')}}">
                    <i class="fas fa-file-alt"></i>
                    <span class="d-none d-lg-inline-block">{{ __('admin/patients_info.nav.pretests')}}</span>
                </a>
            </li>
            <li class="list-inline-item @if ($tab_content_page == 'complaints') active @endif">
                <a href="{{ route('admin.patients.info.complaints',$patient->id) }}" title="{{ __('admin/patients_info.fields.hint_complaints')}}">
                    <i class="fas fa-comments"></i>
                    <span class="d-none d-lg-inline-block">{{ __('admin/patients_info.nav.complaints')}}</span>
                </a>
            </li>
            <li class="list-inline-item @if ($tab_content_page == 'attachments') active @endif">
                <a href="{{ route('admin.patients.info.attachments',$patient->id) }}" title="{{ __('admin/patients_info.fields.hint_attachments')}}">
                    <i class="fas fa-paperclip"></i>
                    <span class="d-none d-lg-inline-block">{{ __('admin/patients_info.nav.attachments')}}</span>
                </a>
            </li>
            <li class="list-inline-item">
                <a href="{{ route('admin.patients.info.sms',$patient->id) }}" title="{{ __('admin/patients_info.nav.hint_sms')}}">
                    <i class="fas fa-sms"></i>
                    <span class="d-none d-lg-inline-block">{{ __('admin/patients_info.nav.sms')}}</span>
                </a>
            </li>
            <li class="list-inline-item">
                <a href="{{ route('admin.patients.info.notifications',$patient->id) }}" title="{{ __('admin/patients_info.nav.hint_notif')}}">
                    <i class="fas fa-flag"></i>
                    <span class="d-none d-lg-inline-block">{{ __('admin/patients_info.nav.notif')}}</span>
                </a>
            </li>
            <li class="list-inline-item">
                <a href="{{ route('admin.patients.info.payments',$patient->id) }}" title="{{ __('admin/patients_info.fields.hint_payment')}}">
                    <i class="fas fa-money-bill-alt"></i>
                    <span class="d-none d-lg-inline-block">{{ __('admin/patients_info.nav.payment')}}</span>
                </a>
            </li>
        </ul>
        @include('admin.patients.tabs_content.' . $tab_content_page)
    </div>
</div>
