<div class="col">
    <table class="table table-bordered table-hover">
        <thead class="bg-light">
            <tr>
                <th class="fit text-center">#</th>
                @foreach ($columns as $col)
                    {!! $col !!}
                @endforeach
            </tr>
        </thead>
        <tbody class="bg-white">
            @if ($rows)
                @foreach ($rows as $index => $row)
                    <tr>
                        <td class="text-center">{{ $first_index++ }}</td>
                        @foreach ($columns as $key => $col)
                            @if ( $key == 'route')
                                @php
                                    $lang_key = str_replace('admin.', 'admin/', $row[$key]);
                                    
                                    $lang_key = str_replace('.save', '.add', $lang_key);
                                    $lang_key = str_replace('.update', '.edit', $lang_key);
                                    $lang_key = str_replace('auth.do_login', 'auth.login', $lang_key);

                                    if ( strpos( $lang_key, '.add') || strpos( $lang_key, '.edit') || strpos( $lang_key, '.info') || strpos( $lang_key, '.logout')){
                                        $lang_key .= '_title';
                                    }else{
                                        $lang_key .= '.title';
                                    }

                                    $row[$key] = __($lang_key);
                                @endphp
                            @endif
                            <td>{{ $row[$key] }}</td>
                        @endforeach
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="{{ count($columns) + 2 }}" class="text-center">
                        {{ __('admin/common.msgs.no_results') }}
                    </td>
                </tr>
            @endif
        </tbody>
    </table>
    @if ($rows)
        <div class="row mt-3 pb-5">
            <div class="col-12 col-lg-auto my-auto">
                <span class="font-italic text-sm">
                    {{ $pagination['msg'] }}
                </span>
            </div>
            <div class="col-12 col-lg-auto ml-auto">
                {{ $pagination['links'] }}
            </div>
        </div>

        <div class="modal fade" id="confirm-delete-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
            aria-labelledby="confirm-delete-modal-label" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="confirm-delete-modal-label">
                            {{ __('admin/common.confirm_modal.title') }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        {{ __('admin/common.confirm_modal.delete_msg') }}
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary mr-auto" data-dismiss="modal"
                            title="{{ __('admin/common.buttons.cancel') }}">{{ __('admin/common.buttons.cancel') }}</button>
                        <a href="#"
                            class="btn btn-danger btn-confirm-delete">{{ __('admin/common.buttons.delete') }}</a>
                    </div>
                </div>
            </div>
        </div>

    @endif

    <script>
        $(document).ready(function() {

            $('.btn-delete').on('click', function(e) {

                e.preventDefault();

                let href = $(this).attr('data-href');

                $('#confirm-delete-modal .btn-confirm-delete').attr('href', href);

                $('#confirm-delete-modal').modal('show');

            });



            $('.btn-filter').on('click', function(e) {
                //let url = window.location.href.split('?')[0];
                let url = '{{ route($baseLink) }}';

                // get rows
                let rows = $('#table-rows-per-page').val();

                if (rows) {
                    url += '?rows=' + rows;
                }

                //get filters
                let filter = $('#table-row-filters').val();

                if (filter) {
                    url += '&filter=' + filter;
                }

                //get search
                let search = $('#table-search').val();

                if (search) {
                    url += '&search=' + search;
                }

                // get sort by
                let sort = $('table th[sorted]').first().attr('data-sort');

                if (sort) {
                    url += '&sort=' + sort;
                }

                // get order by
                let order = $('table th[sorted]').first().attr('data-order');

                if (order) {
                    url += '&order=' + order;
                }

                // append other filters
                let treatment = '{{ request()->query('treatments-filter') }}';

                if (treatment) {
                    url += '&treatment-filter=' + treatment;
                }
                

                let branch = '{{ request()->query('branches-filter') }}';

                if (branch) {
                    url += '&branches-filter=' + branch;
                }

               

                let start_date = '{{ request()->query('start-date') }}';

                if (start_date) {
                    url += '&start-date=' + start_date;
                }

               
                let end_date = '{{ request()->query('end-date') }}';

                if (end_date) {
                    url += '&end-date=' + end_date;
                }

                window.location.href = url;
            });
        });
    </script>
</div>