<?php

use App\Http\Controllers\Admin\AppointmentsController;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\BranchesController;
use App\Http\Controllers\Admin\ComplaintsController;
use App\Http\Controllers\Admin\Dashboard;
use App\Http\Controllers\Admin\LocalizationController;
use App\Http\Controllers\Admin\MailController;
use App\Http\Controllers\Admin\NotificationsController;
use App\Http\Controllers\Admin\OffersController;
use App\Http\Controllers\Admin\PatientsInfoController;
use App\Http\Controllers\Admin\PatientsController;
use App\Http\Controllers\Admin\PretestsController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\RegionsController;
use App\Http\Controllers\Admin\Reports\AppointmentsReportController;
use App\Http\Controllers\Admin\Reports\BookedAppointmentsController;
use App\Http\Controllers\Admin\Reports\PatientHistoryController;
use App\Http\Controllers\Admin\Reports\UserActivityController;
use App\Http\Controllers\Admin\ReviewsController;
use App\Http\Controllers\Admin\RolesController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\SocialAccountsController;
use App\Http\Controllers\Admin\TreatmentCategoriesController;
use App\Http\Controllers\Admin\TreatmentsController;
use App\Http\Controllers\Admin\UsersController;
/* use App\Http\Controllers\Admin\WebsiteAboutPageController;
use App\Http\Controllers\Admin\WebsiteHomePageController;
use App\Http\Controllers\Admin\WebsiteTreatmentsController; */
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/lang', [LocalizationController::class,'index'])->name('admin.set_locale');



Route::prefix('/auth')->name('admin.auth')->group(function(){

    Route::get('/login', [AuthController::class,'login'])->name('.login');
    Route::post('/login', [AuthController::class,'login'])->name('.do_login');

    Route::get('/forgot', [AuthController::class,'forgot'])->name('.forgot');
    Route::post('/forgot', [AuthController::class,'forgot'])->name('.post_forgot');

   /*  Route::get('/reset', [AuthController::class,'resetPass'])->name('.reset');
    Route::post('/reset', [AuthController::class,'resetPass'])->name('.post_reset'); */
});
/**********************************
 * Admin with no auth Auth
 **********************************/
Route::name('admin')->middleware(['admin_auth','branch_filter'])->group(function(){

    Route::get('/cache-clear', function() {
    
        Artisan::call('cache:clear');
        Artisan::call('route:cache');
        Artisan::call('view:clear');
        Artisan::call('config:cache');
      
        dd("cache cleared");
    })->name('admin.clear_cache');
    
    Route::get('/route-clear', function() {
        Artisan::call('route:clear');
        dd("route cleared");

    })->name('admin.clear_route');

    /**********
     * Auth
     *********/
    Route::prefix('auth')->name('.auth')->group(function(){

        Route::get('/logout', [AuthController::class,'logout'])->name('.logout');

    });

    Route::prefix('profile')->name('.profile')->group(function(){

        Route::get('/', [ProfileController::class,'index'])->name('');
        Route::post('/', [ProfileController::class,'index'])->name('.save');

    });


    Route::get('/', [Dashboard::class,'index'])->name('');

    Route::prefix('dashboard')->name('.dashboard')->group(function(){
        
        Route::get('/', [Dashboard::class,'index'])->name('');
        Route::get('/get-free-physicians', [Dashboard::class,'getAvailablePhysicians'])->name('.get_free_physicians');
        Route::get('/get-busy-physicians', [Dashboard::class,'getBusyPhysicians'])->name('.get_busy_physicians');
        Route::get('/get-no-app-patients', [Dashboard::class,'getNoAppPatients'])->name('.get_no_app_patients');
        Route::post('/add-patient-no-app', [Dashboard::class,'addPatientNoApp'])->name('.add_patient_no_app');
        Route::get('/check-in/{appointment:id}', [Dashboard::class,'checkIn'])->name('.check_in');
        Route::post('/admit/{appointment:id}', [Dashboard::class,'admitPatient'])->name('.admit');
        Route::get('/end-session/{appointment:id}', [Dashboard::class,'endSession'])->name('.end_session');
        Route::get('/get-user-notifications', [Dashboard::class,'getNotifications'])->name('.get_notifications');
        Route::get('/mark-as-read/{notification_id?}', [Dashboard::class,'markAsRead'])->name('.mark_as_read');
    });


    
    /************
     * Patients
     ***********/
    Route::prefix('patients')->name('.patients')->group(function(){
        Route::get('/', [PatientsController::class,'index'])->name('');
        Route::get('/add', [PatientsController::class,'add'])->name('.add');
        Route::post('/add', [PatientsController::class,'add'])->name('.save');
        Route::get('/edit/{patient:id}', [PatientsController::class,'edit'])->name('.edit');
        Route::post('/edit/{patient:id}', [PatientsController::class,'edit'])->name('.update');
        Route::get('/delete/{patient:id}', [PatientsController::class,'delete'])->name('.delete');
        Route::get('/export',[PatientsController::class,'export'])->name('.export');
        Route::get('/print/{selection}', [PatientsController::class,'print'])->name('.print');
    });

    /*****************
     * Patient Info
     ****************/
    Route::prefix('patients/info/{patient:id}')->name('.patients.info')->group(function(){

        // Info page
        Route::get('/', [PatientsInfoController::class,'index'])->name('');

        // Comments
        Route::get('/comments', [PatientsInfoController::class,'comments'])->name('.comments');
        Route::post('/comments', [PatientsInfoController::class,'comments'])->name('.comments.add');

        // Appointments
        Route::get('/appointments', [PatientsInfoController::class,'appointments'])->name('.appointments');
        Route::post('/appointments', [PatientsInfoController::class,'appointments'])->name('.appointments.add');

        // Pretests
        Route::get('/pretests', [PatientsInfoController::class,'pretests'])->name('.pretests');
       
        // Complaints
        Route::get('/complaints', [PatientsInfoController::class,'complaints'])->name('.complaints');
        
        // Attachments
        Route::get('/attachments', [PatientsInfoController::class,'attachments'])->name('.attachments');
        Route::get('/attachments/add', [PatientsInfoController::class,'addAttachment'])->name('.attachments.add');
        Route::post('/attachments/add', [PatientsInfoController::class,'addAttachment'])->name('.attachments.save');
        Route::get('/attachments/delete/{attachment_id}', [PatientsInfoController::class,'deleteAttachment'])->name('.attachments.delete');
        Route::get('/attachments/download/{attachment_id}', [PatientsInfoController::class,'downloadAttachment'])->name('.attachments.download');

        // SMS
        Route::get('/sms', [PatientsInfoController::class,'sms'])->name('.sms');

        // Notifications
        Route::get('/notifications', [PatientsInfoController::class,'notifications'])->name('.notifications');
        
        // Payments
        Route::get('/payments', [PatientsInfoController::class,'payments'])->name('.payments');
    
    });

    /***********
     * Regions
     *********/
    Route::prefix('regions')->name('.regions')->group(function(){
        Route::get('/', [RegionsController::class,'index'])->name('');
        Route::get('/add', [RegionsController::class,'add'])->name('.add');
        Route::post('/add', [RegionsController::class,'add'])->name('.save');
        Route::get('/edit/{region:id}', [RegionsController::class,'edit'])->name('.edit');
        Route::post('/edit/{region:id}', [RegionsController::class,'edit'])->name('.update');
        Route::get('/delete/{region:id}', [RegionsController::class,'delete'])->name('.delete');
        Route::get('/print/{selection}', [RegionsController::class,'print'])->name('.print');
    });

    /**************
     * Treatments
     *************/
    Route::prefix('treatments')->name('.treatments')->group(function(){
        Route::get('/', [TreatmentsController::class,'index'])->name('');
        Route::get('/add', [TreatmentsController::class,'add'])->name('.add');
        Route::post('/add', [TreatmentsController::class,'add'])->name('.save');
        Route::get('/edit/{treatment:id}', [TreatmentsController::class,'edit'])->name('.edit');
        Route::post('/edit/{treatment:id}', [TreatmentsController::class,'edit'])->name('.update');
        Route::get('/delete/{treatment:id}', [TreatmentsController::class,'delete'])->name('.delete');
        Route::get('/details/{treatment:id}', [TreatmentsController::class,'details'])->name('.details');
        Route::get('/print/{selection}', [TreatmentsController::class,'print'])->name('.print');
    });
    /***********************
     * Treatment Categories
     ***********************/
    Route::prefix('treatment-categories')->name('.treatment_categories')->group(function(){
        Route::get('/', [TreatmentCategoriesController::class,'index'])->name('');
        Route::get('/add', [TreatmentCategoriesController::class,'add'])->name('.add');
        Route::post('/add', [TreatmentCategoriesController::class,'add'])->name('.save');
        Route::get('/edit/{treatment_category:id}', [TreatmentCategoriesController::class,'edit'])->name('.edit');
        Route::post('/edit/{treatment_category:id}', [TreatmentCategoriesController::class,'edit'])->name('.update');
        Route::get('/delete/{treatment_category:id}', [TreatmentCategoriesController::class,'delete'])->name('.delete');
        Route::get('/print/{selection}', [TreatmentCategoriesController::class,'print'])->name('.print');
    });

    /***********
     * Roles
     **********/
    Route::prefix('roles')->name('.roles')->group(function(){
        Route::get('/', [RolesController::class,'index'])->name('');
        Route::get('/add', [RolesController::class,'add'])->name('.add');
        Route::post('/add', [RolesController::class,'add'])->name('.save');
        Route::get('/edit/{role:id}', [RolesController::class,'edit'])->name('.edit');
        Route::post('/edit/{role:id}', [RolesController::class,'edit'])->name('.update');
        Route::get('/delete/{role:id}', [RolesController::class,'delete'])->name('.delete');
        Route::get('/print/{selection}', [RolesController::class,'print'])->name('.print');
        
    });

    /**************
     * Users
     *************/
    Route::prefix('users')->name('.users')->group(function(){
        Route::get('/', [UsersController::class,'index'])->name('');
        Route::get('/add', [UsersController::class,'add'])->name('.add');
        Route::post('/add', [UsersController::class,'add'])->name('.save');
        Route::get('/edit/{user:id}', [UsersController::class,'edit'])->name('.edit');
        Route::post('/edit/{user:id}', [UsersController::class,'edit'])->name('.update');
        Route::get('/delete/{user:id}', [UsersController::class,'delete'])->name('.delete');
        Route::get('/print/{selection}', [UsersController::class,'print'])->name('.print');
    });

    /*****************
     * Appointments
     ****************/
    Route::prefix('appointments')->name('.appointments')->group(function(){
        //Route::get('/{patient_id?}', [AppointmentsController::class,'index'])->name('');
        Route::get('/', [AppointmentsController::class,'index'])->name('');
        Route::get('/add', [AppointmentsController::class,'add'])->name('.add');
        Route::post('/add', [AppointmentsController::class,'add'])->name('.save');
        Route::get('/get-branches', [AppointmentsController::class,'getBranches'])->name('.get_branches');
        Route::get('/get-treatments/{branch_id?}', [AppointmentsController::class,'getTreatments'])->name('.get_treatments');
        Route::get('/get-calendar/{patient_id?}/{branch_id?}/{treatment_id?}/{week_number?}', [AppointmentsController::class,'getCalendar'])->name('.get_calendar');
        Route::get('/info/{appointment:id}', [AppointmentsController::class,'info'])->name('.info');
        Route::get('/check-in/{appointment:id}', [AppointmentsController::class,'checkIn'])->name('.check_in');
        Route::get('/postpone/{appointment:id}', [AppointmentsController::class,'postpone'])->name('.postpone');
        Route::post('/postpone/{appointment:id}', [AppointmentsController::class,'postpone'])->name('.update');
        Route::get('/admit/{appointment:id}', [AppointmentsController::class,'admit'])->name('.admit');
        Route::get('/delete/{appointment_id}', [AppointmentsController::class,'delete'])->name('.delete');
        Route::get('/print/{selection}', [AppointmentsController::class,'print'])->name('.print');
        Route::get('/export',[AppointmentsController::class,'export'])->name('.export');
    });

    /*****************
     * Complaints
     ****************/
    Route::prefix('complaints')->name('.complaints')->group(function(){
        Route::get('/', [ComplaintsController::class,'index'])->name('');
        Route::get('/add', [ComplaintsController::class,'add'])->name('.add');
        Route::post('/add', [ComplaintsController::class,'add'])->name('.save');
        Route::get('/resolved/{complaint:id}', [ComplaintsController::class,'resolved'])->name('.resolved');
        Route::get('/info/{complaint:id}', [ComplaintsController::class,'info'])->name('.info');
        Route::get('/download/{complaint:id}', [ComplaintsController::class,'downloadAttachment'])->name('.download');
        Route::post('/add-comment', [ComplaintsController::class,'addComment'])->name('.add_comment');
        Route::get('/messages/refresh/{complaint_id}/{last_msg_id?}', [ComplaintsController::class,'refreshMessageBox'])->name('.refresh_messages');
        Route::get('/print/{selection}', [ComplaintsController::class,'print'])->name('.print');
    });

    /*****************
     * Branches
     ****************/
    Route::prefix('branches')->name('.branches')->group(function(){
        Route::get('/', [BranchesController::class,'index'])->name('');
        Route::get('/add', [BranchesController::class,'add'])->name('.add');
        Route::post('/add', [BranchesController::class,'add'])->name('.save');
        Route::get('/edit/{branch:id}', [BranchesController::class,'edit'])->name('.edit');
        Route::post('/edit/{branch:id}', [BranchesController::class,'edit'])->name('.update');
        Route::get('/delete/{branch_id}', [BranchesController::class,'delete'])->name('.delete');
        Route::get('/print/{selection}', [BranchesController::class,'print'])->name('.print');
    });

    /*****************
     * Pretest
     ****************/
    Route::prefix('pretests')->name('.pretests')->group(function(){
        Route::get('/', [PretestsController::class,'index'])->name('');
        Route::get('/add', [PretestsController::class,'add'])->name('.add');
        Route::post('/add', [PretestsController::class,'add'])->name('.save');
        Route::get('/edit/{patient_pretest:id}', [PretestsController::class,'edit'])->name('.edit');
        Route::post('/edit/{patient_pretest:id}', [PretestsController::class,'edit'])->name('.update');
        Route::get('/delete/{patient_pretest:id}', [PretestsController::class,'delete'])->name('.delete');
        Route::get('/info/{pretest_id}', [PretestsController::class,'info'])->name('.info');
        Route::get('/get_form/{patient_id?}/{pretest_id?}', [PretestsController::class,'getForm'])->name('.get_form');
        Route::get('/download/{pid}/{attachment}', [PretestsController::class,'downloadAttachment'])->name('.download');
        Route::get('/print/{selection}', [PretestsController::class,'print'])->name('.print');
    });

    /*****************
    * Notifications
    ****************/
    Route::prefix('notifications')->name('.notifications')->group(function(){
        Route::get('/', [NotificationsController::class,'index'])->name('');
        Route::post('/send', [NotificationsController::class, 'send'])->name('.send');
    });

     /*****************
     * Website
     ****************/
    /* Route::prefix('website')->name('.website')->group(function(){
        Route::get('/', [WebsiteHomePageController::class,'index'])->name('');
        Route::get('/home', [WebsiteHomePageController::class,'index'])->name('.home');
        Route::post('/home', [WebsiteHomePageController::class,'index'])->name('.save_home');
        Route::get('/about', [WebsiteAboutPageController::class,'index'])->name('.about');
        Route::post('/about', [WebsiteAboutPageController::class,'edit'])->name('.save_about');
        Route::get('/treatments', [WebsiteTreatmentsController::class,'index'])->name('.treatments');
        Route::post('/treatments', [WebsiteTreatmentsController::class,'edit'])->name('.save_treatments');
    }); */
    /*****************
    * Social Account
    *****************/
    Route::prefix('social_accounts')->name('.social_accounts')->group(function(){
        Route::get('/', [SocialAccountsController::class,'index'])->name('');
        Route::get('/add', [SocialAccountsController::class,'add'])->name('.add');
        Route::post('/add', [SocialAccountsController::class,'add'])->name('.save');
        Route::get('/edit/{social_account:id}', [SocialAccountsController::class,'edit'])->name('.edit');
        Route::post('/edit/{social_account:id}', [SocialAccountsController::class,'edit'])->name('.update');
        Route::get('/delete/{social_account:id}', [SocialAccountsController::class,'delete'])->name('.delete');
    });
    /*****************
    * Offers
    *****************/
    Route::prefix('offers')->name('.offers')->group(function(){
        Route::get('/', [OffersController::class,'index'])->name('');
        Route::get('/add', [OffersController::class,'add'])->name('.add');
        Route::post('/add', [OffersController::class,'add'])->name('.save');
        Route::get('/edit/{offer:id}', [OffersController::class,'edit'])->name('.edit');
        Route::post('/edit/{offer:id}', [OffersController::class,'edit'])->name('.update');
        Route::get('/delete/{offer:id}', [OffersController::class,'delete'])->name('.delete');
    });
    /*****************
    * Reviews
    *****************/
    Route::prefix('reviews')->name('.reviews')->group(function(){
        Route::get('/', [ReviewsController::class,'index'])->name('');
        Route::get('/info', [ReviewsController::class,'add'])->name('.info');
    });

    /*****************
    * Settings
    *****************/
    Route::prefix('settings')->name('.settings')->group(function(){
        Route::get('/', [SettingsController::class,'index'])->name('');
        Route::post('/', [SettingsController::class,'save'])->name('.save');
    });

    /*****************
    * Reports
    *****************/
    Route::prefix('reports')->name('.reports')->group(function(){

        Route::get('/patient-history/print/{patient?}/{selection}', [PatientHistoryController::class,'print'])->name('.patient_history.print');
        Route::get('/patient-history', [PatientHistoryController::class,'index'])->name('.patient_history');
        Route::post('/patient-history', [PatientHistoryController::class,'index'])->name('.get_patient_history');

        Route::get('/most-booked-appointments', [BookedAppointmentsController::class,'index'])->name('.booked_appointments');
        Route::get('/most-booked-appointments/print/{selection}', [BookedAppointmentsController::class,'print'])->name('.booked_appointments.print');
        
        Route::get('/user-activity', [UserActivityController::class,'index'])->name('.user_activity');
        Route::get('/user-activity/print/{selection}', [UserActivityController::class,'print'])->name('.user_activity.print');
    
        Route::get('/appointments-report', [AppointmentsReportController::class,'index'])->name('.appointments');
        Route::get('/appointments-report/print/{selection}', [AppointmentsReportController::class,'print'])->name('.appointments.print');
    
    });

    /*****************
    * Mailbox
    *****************/
    Route::prefix('mail')->name('.mail')->group(function(){

        Route::get('/', [MailController::class,'index'])->name('');
        Route::get('/inbox', [MailController::class,'index'])->name('.inbox');

    });



});


