<?php

namespace App\Console\Commands;

use App\Models\Appointment;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class EndSessionCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'end_session:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'End started session automatically after 10 minutes from their expected end time';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Get current date
        $today = date('Y-m-d');

        // Get today's appointments that have started but not finished
        $active_appointments = Appointment::where('appointment_date',$today)
                                                        ->whereNotNull('admitted_at')
                                                        ->whereNull('finished_at')
                                                        ->get();
        if ( $active_appointments ){

            foreach ( $active_appointments as $appointment ){

                // get admitted_at time (actual starting time)
                $admitted_at = $appointment->admitted_at;

                // get the expected treatment period in minutes
                $period = $appointment->treatment->session_period;

                // get end time
                $end_time = date('H:i', strtotime($admitted_at . '+' . $period.' minutes') );

                // get current time
                $current_time = date('H:i');

                // calculate the difference in minutes
                $diff_in_minutes = ( strtotime($current_time) - strtotime($end_time) ) / 60;

                if ( $diff_in_minutes >= 10 ){

                    $appointment->update(['finished_at' => $current_time,'auto_ended' => 1 ]);

                }

            }
        }
                                            
    }
}
