<?php 

namespace App\Http\Controllers\Admin;

use App\Models\User;
use App\Rules\ComplexPassword;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller{

    public function index(Request $request){

        if ( $request->method() == 'POST' ){

            $validated = $request->validate([
                'password' => ['required','min:8','max:30',new ComplexPassword],
            ]);

            // update password in db
            User::where('id', user_id())->update(['password'=> Hash::make($validated['password'])]);


            // update cpanel email password

            return redirect()->route('admin.auth.logout');

        }

        $data['gen_password'] = rand_password(12);

        $data['user'] = User::findOrFail(user_id());

        $this->loadView('profile.index','profile.title','profile',[],$data);

    }

}