<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\Treatment;
use Illuminate\Http\Request;

class Treatments extends Controller
{

    /**
     * Get treatment categories by branch id
     *
     * @param int $branch_id
     * @return void
     */
    public function getTreatmentCategoriesByBranch($branch_id){

        // get treatment ids for that branch
        $treatments = Branch::with(['treatments' => function ($q) {
            $q->orderBy('treatment');
        }])->find($branch_id)->treatments;

        $treatment_categories = [];

        $ids = []; // to get only unique treatment categories
        foreach ( $treatments as $treatment ){

            if ( !in_array($treatment->category->id,$ids)){

                $treatment_categories[] = [
                    'id' => $treatment->category->id,
                    'name' => $treatment->category->name,
                ]; 
    
                $ids[] = $treatment->category->id;
            }
            
        }

        return response()->json(['categories' => $treatment_categories],200);
    }

    //---------------------------------------------------------

    /**
     * Get Treatment By Category
     *
     * @param int $cate_id
     * @return void
     */
    public function getCategoryTreatments($cate_id){

        $treatments = Treatment::select(['id','treatment'])->where('category_id',$cate_id)->get();

        return response()->json(['treatments' => $treatments],200);

    }

    //---------------------------------------------------------

    public function getTreatmentInfo($treatment_id){

        $treatment = Treatment::findOrFail($treatment_id);

        $data = [
            'treatment_id' => $treatment_id,
            'treatment' => $treatment->treatment,
            'category_id' => $treatment->category->id,
            'category' => $treatment->category->name,
        ];

        return response()->json(['treatment' => $treatment],200);

    }


}
