<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Patient\Controller;
use App\Libraries\PatientCommon;
use App\Models\Patient;
use App\Models\Region;
use App\Rules\Mobile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class PatientAuthController extends Controller
{
    public function index()
    {
        $this->loadView('login', 'login.title', 'login');
    }

    //------------------------------------------------------

    public function login(Request $request)
    {
        if ($request->getMethod() == 'POST') {

            $patient_account = new PatientCommon();

            $result = $patient_account->login($request);

            if ($result == true) {

                return redirect()->route('patient.dashboard');
            } else {

                $this->loadView('login', 'login.title', 'login');
            }
        } else {
            $this->loadView('login', 'login.title', 'login');
        }
    }
    //-----------------------------------------------------
    public function register(Request $request)
    {

        if ($request->method() == 'POST') {

            $patient_common = new PatientCommon();

            $patient_common->register($request, true);

            $result = $patient_common->getResponse();

            if (empty($result)) {

                session()->put('ver_no', $request->input('mobile'));

                // generate otp code
                $otp_code = $patient_common->genOtpCode();

                $patient_common->saveOtpCode($request->input('mobile'), $otp_code);

                // send sms
                $message = sprintf(__('sms.messages.verify'), $otp_code);
                
                send_sms($request->input('mobile'),$message);

                return redirect()->route('patient.verify');
            }
        }

        $data['regions'] = Region::get();

        $this->loadView('register', 'register.title', 'register', [], $data, ['bs-datepicker/dp-bs-4.min.css'], ['momentjs/moment.min.js', 'bs-datepicker/dp-bs-4.min.js']);
    }
    //-----------------------------------------------------
    /**
     * Verify otp 
     * Used for both new account registration AND password reset
     *
     * @param Request $request
     * @return void
     */
    public function verify(Request $request)
    {

        if ($request->method() == 'POST') {

            $validated = $request->validate([
                'code' => ['required', 'integer', 'digits:6']
            ]);

            $db_otp_row = DB::table('patient_otp')->where('mobile', session('ver_no'))->first();

            if ($db_otp_row) {

                if (Hash::check($request->input('code'), $db_otp_row->code)) {

                    Patient::where('mobile', session('ver_no'))->update(['is_verified' => 1]);

                    DB::table('patient_otp')->where('mobile', session('ver_no'))->delete();

                    return redirect()->route('patient.login')->with('success', 'Verified');
                } else {
                    session()->flash('error', 'Invalid key');
                }
            } else {
                session()->flash('error', 'Unknown error occurred');
            }
        }

        $this->loadView('verify', 'verify.title', 'verify');
    }
    //-----------------------------------------------------
    public function forgot(Request $request)
    {

        if ($request->method() == 'POST') {

            $validated = $request->validate([
                'mobile' => ['required', new Mobile, 'exists:patients,mobile'],
            ]);

            $new_password = Str::random(10);

            // update new password AND remove the device token to logout from the mobile app
            Patient::where('mobile', $validated['mobile'])->update(['password' => Hash::make($new_password), 'device_token' => null]);

            // send sms
            $message = sprintf(__('sms.messages.reset'), $new_password);
                
            send_sms($request->input('mobile'),$message);

            return redirect()->route('patient.login')->with('success', 'New password has been sent to your mobile.');
        }

        $this->loadView('forgot', 'forgot.title', 'forgot');
    }
    //-----------------------------------------------------
    public function logout()
    {

        if (session()->has('patient_info')) {

            session()->pull('patient_info');

            return redirect()->route('patient.login');
        } else {

            return redirect()->back();
        }
    }
    //-----------------------------------------------------

}
