<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

/**
 * Allows arabic, english, numeric, dashes, underscores, spaces, periods, and colones
 */
class GeneralText implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        
        /*return !preg_match('/[\'^£$%&*()}{@#~?><>,|=_+¬-]/', $value);*/
        
        return (bool) preg_match('/^[\p{Arabic}a-zA-Z0-9\r\n\&\,\(\)\،\+ \.\_\-\\p{N}]+\h?[\p{N}\p{Arabic}a-zA-Z0-9\r\n \.\_\+\(\)\&\,\،\-]*$/u', $value);
        
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return trans('validation.general_text');
    }
}
