<?php

namespace App\View\Components\Admin\Form;

use Illuminate\View\Component;

class PrintButton extends Component
{

    public $routeName;
    public $params;
    public $all;
    public $current;

    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct(string $routeName, array $params = [])
    {

        $query_string = request()->query();

        $args = '';

        if ( $query_string ) {

            $args = '?';

            foreach ( $query_string as $key => $value ) {
                
                $args .= $key .'='. $value;

            }

        }

        $params['selection'] = 'all';
        $this->all = route($routeName.'.print',$params) . $args;

        $params['selection'] = 'current';
        $this->current = route($routeName.'.print',$params) . $args;

    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        return view('components.admin.form.print-button');
    }
}
