<?php

/*
|--------------------------------------------------------------------------
| Validation Language Lines
|--------------------------------------------------------------------------
|
| The following language lines contain the default error messages used by
| the validator class. Some of these rules have multiple versions such
| as the size rules. Feel free to tweak each of these messages here.
|
*/

return [
    'accepted'             => 'يجب قبول :attribute.',
    'accepted_if'          => 'يجب قبول :attribute في حالة :other يساوي :value.',
    'active_url'           => 'حقل :attribute لا يُمثّل رابطًا صحيحًا.',
    'after'                => 'يجب على حقل :attribute أن يكون تاريخًا لاحقًا للتاريخ :date.',
    'after_or_equal'       => 'حقل :attribute يجب أن يكون تاريخاً لاحقاً أو مطابقاً للتاريخ :date.',
    'alpha'                => 'يجب أن لا يحتوي حقل :attribute سوى على حروف.',
    'alpha_dash'           => 'يجب أن لا يحتوي حقل :attribute سوى على حروف، أرقام و dashes.',
    'alpha_num'            => 'يجب أن يحتوي حقل :attribute على حروفٍ وأرقامٍ فقط.',
    'array'                => 'يجب أن يكون حقل :attribute ًمصفوفة.',
    'attached'             => 'حقل :attribute تم إرفاقه بالفعل.',
    'before'               => 'يجب على حقل :attribute أن يكون تاريخًا سابقًا للتاريخ :date.',
    'before_or_equal'      => 'حقل :attribute يجب أن يكون تاريخا سابقا أو مطابقا للتاريخ :date.',
    'between'              => [
        'array'   => 'يجب أن يحتوي حقل :attribute على عدد من العناصر بين :min و :max.',
        'file'    => 'يجب أن يكون حجم ملف حقل :attribute بين :min و :max كيلوبايت.',
        'numeric' => 'يجب أن تكون قيمة حقل :attribute بين :min و :max.',
        'string'  => 'يجب أن يكون عدد حروف نّص حقل :attribute بين :min و :max.',
    ],
    'boolean'              => 'يجب أن تكون قيمة حقل :attribute إما true أو false .',
    'confirmed'            => 'حقل التأكيد غير مُطابق للحقل :attribute.',
    'current_password'     => 'كلمة المرور غير صحيحة.',
    'date'                 => 'حقل :attribute ليس تاريخًا صحيحًا.',
    'date_equals'          => 'يجب أن يكون حقل :attribute مطابقاً للتاريخ :date.',
    'date_format'          => 'لا يتوافق حقل :attribute مع الشكل :format.',
    'different'            => 'يجب أن يكون الحقلان :attribute و :other مُختلفين.',
    'digits'               => 'يجب أن يحتوي حقل :attribute على :digits رقمًا/أرقام.',
    'digits_between'       => 'يجب أن يحتوي حقل :attribute بين :min و :max رقمًا/أرقام .',
    'dimensions'           => 'الحقل:attribute يحتوي على أبعاد صورة غير صالحة.',
    'distinct'             => 'للحقل :attribute قيمة مُكرّرة.',
    'email'                => 'يجب أن يكون حقل :attribute عنوان بريد إلكتروني صحيح البُنية.',
    'ends_with'            => 'يجب أن ينتهي حقل :attribute بأحد القيم التالية: :values',
    'exists'               => 'القيمة المحددة :attribute غير موجودة.',
    'file'                 => 'الحقل :attribute يجب أن يكون ملفا.',
    'filled'               => 'حقل :attribute إجباري.',
    'gt'                   => [
        'array'   => 'يجب أن يحتوي حقل :attribute على أكثر من :value عناصر/عنصر.',
        'file'    => 'يجب أن يكون حجم ملف حقل :attribute أكبر من :value كيلوبايت.',
        'numeric' => 'يجب أن تكون قيمة حقل :attribute أكبر من :value.',
        'string'  => 'يجب أن يكون طول نّص حقل :attribute أكثر من :value حروفٍ/حرفًا.',
    ],
    'gte'                  => [
        'array'   => 'يجب أن يحتوي حقل :attribute على الأقل على :value عُنصرًا/عناصر.',
        'file'    => 'يجب أن يكون حجم ملف حقل :attribute على الأقل :value كيلوبايت.',
        'numeric' => 'يجب أن تكون قيمة حقل :attribute مساوية أو أكبر من :value.',
        'string'  => 'يجب أن يكون طول نص حقل :attribute على الأقل :value حروفٍ/حرفًا.',
    ],
    'image'                => 'يجب أن يكون حقل :attribute صورةً.',
    'in'                   => 'حقل :attribute غير موجود.',
    'in_array'             => 'حقل :attribute غير موجود في :other.',
    'integer'              => 'يجب أن يكون حقل :attribute عددًا صحيحًا.',
    'ip'                   => 'يجب أن يكون حقل :attribute عنوان IP صحيحًا.',
    'ipv4'                 => 'يجب أن يكون حقل :attribute عنوان IPv4 صحيحًا.',
    'ipv6'                 => 'يجب أن يكون حقل :attribute عنوان IPv6 صحيحًا.',
    'json'                 => 'يجب أن يكون حقل :attribute نصًا من نوع JSON.',
    'lt'                   => [
        'array'   => 'يجب أن يحتوي حقل :attribute على أقل من :value عناصر/عنصر.',
        'file'    => 'يجب أن يكون حجم ملف حقل :attribute أصغر من :value كيلوبايت.',
        'numeric' => 'يجب أن تكون قيمة حقل :attribute أصغر من :value.',
        'string'  => 'يجب أن يكون طول نّص حقل :attribute أقل من :value حروفٍ/حرفًا.',
    ],
    'lte'                  => [
        'array'   => 'يجب أن لا يحتوي حقل :attribute على أكثر من :value عناصر/عنصر.',
        'file'    => 'يجب أن لا يتجاوز حجم ملف حقل :attribute :value كيلوبايت.',
        'numeric' => 'يجب أن تكون قيمة حقل :attribute مساوية أو أصغر من :value.',
        'string'  => 'يجب أن لا يتجاوز طول نّص حقل :attribute :value حروفٍ/حرفًا.',
    ],
    'max'                  => [
        'array'   => 'يجب أن لا يحتوي حقل :attribute على أكثر من :max عناصر/عنصر.',
        'file'    => 'يجب أن لا يتجاوز حجم ملف حقل :attribute :max كيلوبايت.',
        'numeric' => 'يجب أن تكون قيمة حقل :attribute مساوية أو أصغر من :max.',
        'string'  => 'يجب أن لا يتجاوز طول نّص حقل :attribute :max حروفٍ/حرفًا.',
    ],
    'mimes'                => 'يجب أن يكون ملفًا من نوع : :values.',
    'mimetypes'            => 'يجب أن يكون ملفًا من نوع : :values.',
    'min'                  => [
        'array'   => 'يجب أن يحتوي حقل :attribute على الأقل على :min عُنصرًا/عناصر.',
        'file'    => 'يجب أن يكون حجم ملف حقل :attribute على الأقل :min كيلوبايت.',
        'numeric' => 'يجب أن تكون قيمة حقل :attribute مساوية أو أكبر من :min.',
        'string'  => 'يجب أن يكون طول نص حقل :attribute على الأقل :min حروفٍ/حرفًا.',
    ],
    'multiple_of'          => 'حقل :attribute يجب أن يكون من مضاعفات :value',
    'not_in'               => 'عنصر الحقل :attribute غير صحيح.',
    'not_regex'            => 'صيغة حقل :attribute غير صحيحة.',
    'numeric'              => 'يجب على حقل :attribute أن يكون رقمًا.',
    'password'             => 'كلمة المرور غير صحيحة.',
    'present'              => 'يجب تقديم حقل :attribute.',
    'prohibited'           => 'حقل :attribute محظور.',
    'prohibited_if'        => 'حقل :attribute محظور إذا كان :other هو :value.',
    'prohibited_unless'    => 'حقل :attribute محظور ما لم يكن :other ضمن :values.',
    'prohibits'            => 'الحقل :attribute يحظر تواجد الحقل :other.',
    'regex'                => 'صيغة حقل :attribute .غير صحيحة.',
    'relatable'            => 'حقل :attribute قد لا يكون مرتبطا بالمصدر المحدد.',
    'required'             => 'حقل :attribute مطلوب.',
    'required_if'          => 'حقل :attribute مطلوب في حال ما إذا كان :other يساوي :value.',
    'required_unless'      => 'حقل :attribute مطلوب في حال ما لم يكن :other يساوي :values.',
    'required_with'        => 'حقل :attribute مطلوب إذا توفّر :values.',
    'required_with_all'    => 'حقل :attribute مطلوب إذا توفّر :values.',
    'required_without'     => 'حقل :attribute مطلوب إذا لم يتوفّر :values.',
    'required_without_all' => 'حقل :attribute مطلوب إذا لم يتوفّر :values.',
    'same'                 => 'يجب أن يتطابق حقل :attribute مع :other.',
    'size'                 => [
        'array'   => 'يجب أن يحتوي حقل :attribute على :size عنصرٍ/عناصر بالضبط.',
        'file'    => 'يجب أن يكون حجم ملف حقل :attribute :size كيلوبايت.',
        'numeric' => 'يجب أن تكون قيمة حقل :attribute مساوية لـ :size.',
        'string'  => 'يجب أن يحتوي نص حقل :attribute على :size حروفٍ/حرفًا بالضبط.',
    ],
    'starts_with'          => 'يجب أن يبدأ حقل :attribute بأحد القيم التالية: :values',
    'string'               => 'يجب أن يكون حقل :attribute نصًا.',
    'timezone'             => 'يجب أن يكون حقل :attribute نطاقًا زمنيًا صحيحًا.',
    'unique'               => 'قيمة حقل :attribute مُستخدمة من قبل.',
    'uploaded'             => 'فشل في تحميل الـ :attribute.',
    'url'                  => 'صيغة رابط حقل :attribute غير صحيحة.',
    'uuid'                 => 'حقل :attribute يجب أن يكون بصيغة UUID سليمة.',

    // Custom rules 
    'alpha_space' => 'الحقل :attribute يمكن أن يحتوى على حروف عربية، إنجليزية، و مسافات فقط.',
    'mobile' => 'يرجى التأكد من الحقل :attribute',
    'phone' => 'يرجى التأكد من الحقل :attribute',
    'general_text' => 'الحقل :attribute يمكن أن يحتوي على حروف عربية، إنجليزية، أرقام، مسافات، فواصل، نقاط و dashes و undescores',
    'ar_en_alpha_num_space' => 'الحقل :attributte يمكن أن يحتوي على حروف عربية، إنجليزية، أرقام، ومسافات فقط',
    'ar_alpha_space' => 'الحقل :attribute يمكن أن يحتوي على حروف عربية، و مسافات',
    'ar_alpha_numeric_space' => 'الحقل :attributte يمكن أن يحتوي على حروف عربية، أرقام، ومسافات فقط',
    'ar_alpha_numeric_space_dash' => 'الحقل :attribute يمكن أن يحتوي على حروف عربية، أرقام، مسافات، و dashes و undescores',
    'ar_general' => 'الحقل :attribute يمكن أن يحتوي على حروف عربية، أرقام، مسافات، فواصل، نقاط و dashes و undescores',
    'en_alpha_space_dash' => 'الحقل :attribute يمكن أن يحتوي على حروف ،مسافات  dashes',


    /* 'custom'               => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ], */

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'address' => 'العنوان',
        'ap-date' => 'تاريخ الموعد',
        'ap-session' => 'وقت الموعد',
        'attachment' => 'المرفقات',
        'attachment-title' => 'عنوان المرفق',
        'patient-attachment' => 'المرفق',
        'branch' => 'الفرع',
        'branches' => 'الفروع',
        'category' => 'اسم المجموعة',
        'comment' => 'الملاحظات',
        'complaint-date' => 'تاريخ الشكوى',
        'conflict-treatments' => 'العلاجات الماعارضة',
        'cpassword' => 'تأكيد كلمة المرور',
        'description' => 'الوصف',
        'dob' => 'تاريخ الميلاد',
        'email' => 'البريد الإلكتروني',
        'end_time' => 'وقت النهاية',
        'first-name' => 'الاسم الأول',
        'last-name' => 'اسم العائلة',
        'message' => 'الرسالة',
        'min-sessions' => 'عدد الجلسات',
        'mobile' => 'رقم الموبايل',
        'name' => 'الاسم',
        'patient' => 'المراجع',
        'password' => 'كلمة المرور',
        'phone' => 'رقم الهاتف',
        'pretests' => 'الفحوصات',
        'price' => 'السعر',
        'treatment-prices' => 'السعر',
        'region' => 'المنطقة',
        'role' => 'اسم المجموعة',
        'second-name' => 'اسم الأب',
        'session' => 'الموعد',
        'session-date' => 'تاريخ الجلسة',
        'session-number' => 'رقم الجلسة',
        'session-type' => 'نوع الجلسة',
        'session-rooms' => 'عددالأجهزة أو الغرف',
        'start_time' => 'وقت البداية',
        'third-name' => 'اسم الجد',
        'treatment' => 'العلاج',
        'treatment-devices' => 'الأجهزة أو الغرف',
        'q1' => 'السؤال الأول',
        'q2' => 'السؤال الثاني',
        'q3' => 'السؤال الثالث',
        'q4' => 'السؤال الرابع',
        'q5' => 'السؤال الخامس',
        'q6' => 'السؤال السادس',
        'q7' => 'السؤال السابع',
        'q8' => 'السؤال الثامن',
        'q9' => 'السؤال التاسع',
        'q10' => 'السؤال العاشر',
        'q11' => 'السؤال الحادي عشر',
        'q12' => 'السؤال الثاني عشر',
        'q13' => 'السؤال الثالث عشر',
        'q14' => 'السؤال الرابع عشر',
        'q1-input' => 'توضيح السؤال الأول',
        'q2-input' => 'توضيح السؤال الثاني',
        'q3-input' => 'توضيح السؤال الثالث',
        'q4-input' => 'توضيح السؤال الرابع',
        'q5-input' => 'توضيح السؤال الخامس',
        'q6-input' => 'توضيح السؤال السادس',
        'q7-input' => 'توضيح السؤال السابع',
        'q8-input' => 'توضيح السؤال الثامن',
        'q9-input' => 'توضيح السؤال التاسع',
        'q10-input' => 'توضيح السؤال العاشر',
        'q11-input' => 'توضيح السؤال الحادي عشر',
        'q12-input' => 'توضيح السؤال الثاني عشر',
        'q13-input' => 'توضيح السؤال الثالث عشر',
        'q14-input' => 'توضيح السؤال الرابع عشر',
    ],
];