<aside class="main-sidebar sidebar-dark-primary">
    @if (config('admin.site_logo'))
        <a href="{{ route('admin.dashboard') }}" class="brand-link text-left">
            <img src="{{ asset(config('admin.site_logo')) }}" alt="{{ config('app.name') }}"
                class="brand-image img-circle elevation-3" style="opacity: .8">
            <span class="brand-text font-weight-light">{{ config('app.name') }}</span>
        </a>
        {{-- <div class="d-flex w-100">
            <a href="{{ route('admin.dashboard') }}" class="mx-auto">
                <img src="{{ asset(config('admin.site_logo')) }}" alt="{{ config('app.name') }}"
                    class="brand-image img-circle elevation-1 img-fluid" style="opacity: .8">
            </a>
        </div> --}}
    @else
        <a href="{{ route('admin.dashboard') }}" class="brand-link text-center">
            <span class="brand-text font-weight-light">{{ config('app.name') }}</span>
        </a>
    @endif
    <div class="sidebar pb-5">
        @if (user_id())
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                <div class="info text-white">
                    <span class="text-sm text-light">
                        {{ __('admin/common.text.welcome') }},
                        {{ user_name() }}
                    </span><br>
                    <a href="{{ route('admin.auth.logout') }}" class="text-sm">
                        {{ __('admin/auth.logout') }}
                    </a>
                </div>
            </div>
        @endif
        <div class="form-inline">
            <div class="input-group input-group-sm" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar" type="search" placeholder="Search" aria-label="Search">
                <div class="input-group-append">
                    <button class="btn btn-sidebar">
                        <i class="fas fa-search fa-fw"></i>
                    </button>
                </div>
            </div>
        </div>
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column nav-collapse-hide-child nav-child-indent nav-flat @if (app()->getLocale() == 'en') text-sm @endif"
                data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-item">
                    <a href="{{ route('admin.dashboard') }}" class="nav-link">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                            {{ __('admin/sidebar.dashboard') }}
                        </p>
                    </a>
                </li>
                @if (has_permission('admin.appointments') || has_permission('admin.patients') || has_permission('admin.pretests') || has_permission('admin.complaints') || has_permission('admin.offers'))
                    <li class="nav-header text-uppercase">{{ __('admin/sidebar.title.patients') }}</li>
                    @if (has_permission('admin.appointments'))
                        <li class="nav-item">
                            <a href="{{ route('admin.appointments') }}" class="nav-link">
                                <i class="nav-icon far fa-calendar-alt"></i>
                                <p>
                                    {{ __('admin/sidebar.appointments') }}
                                </p>
                            </a>
                        </li>
                    @endif
                    @if (has_permission('admin.patients'))
                        <li class="nav-item">
                            <a href="{{ route('admin.patients') }}" class="nav-link">
                                <i class="nav-icon fas fa-procedures"></i>
                                <p>
                                    {{ __('admin/sidebar.patients') }}
                                </p>
                            </a>
                        </li>
                    @endif
                    @if (has_permission('admin.pretests'))
                        <li class="nav-item">
                            <a href="{{ route('admin.pretests') }}" class="nav-link">
                                <i class="nav-icon fas fa-stethoscope"></i>
                                <p>
                                    {{ __('admin/sidebar.pretests') }}
                                </p>
                            </a>
                        </li>
                    @endif
                    @if (has_permission('admin.complaints'))
                        <li class="nav-item">
                            <a href="{{ route('admin.complaints') }}" class="nav-link">
                                <i class="nav-icon fas fa-comment-medical"></i>
                                <p>
                                    {{ __('admin/sidebar.complaints') }}
                                </p>
                            </a>
                        </li>
                    @endif
                    @if (has_permission('admin.offers'))
                        <li class="nav-item">
                            <a href="{{ route('admin.offers') }}" class="nav-link">
                                <i class="nav-icon fas fa-gift"></i>
                                <p>
                                    {{ __('admin/sidebar.offers') }}
                                </p>
                            </a>
                        </li>
                    @endif
                @endif
                @if (has_permission('admin.treatments') || has_permission('admin.treatment_categories') || has_permission('admin.branches') || has_permission('admin.regions') || has_permission('admin.roles') || has_permission('admin.users') || has_permission('admin.reviews'))
                    <!-- Center Management -->
                    <li class="nav-header text-uppercase">{{ __('admin/sidebar.title.center') }}</li>
                    @if (has_permission('admin.branches'))
                        <li class="nav-item">
                            <a href="{{ route('admin.branches') }}" class="nav-link">
                                <i class="nav-icon fas fa-hospital"></i>
                                <p>
                                    {{ __('admin/sidebar.branches') }}
                                </p>
                            </a>
                        </li>
                    @endif
                    @if (has_permission('admin.treatments') || has_permission('admin.treatment_categories'))
                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-hand-holding-medical"></i>
                                <p>{{ __('admin/sidebar.treatments') }}<i class="right fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview">
                                @if (has_permission('admin.treatment_categories'))
                                    <li class="nav-item">
                                        <a href="{{ route('admin.treatment_categories') }}" class="nav-link">
                                            <i class="fas fa-folder-plus nav-icon"></i>
                                            <p>{{ __('admin/sidebar.treatment_categories') }}</p>
                                        </a>
                                    </li>
                                @endif
                                @if (has_permission('admin.treatments'))
                                    <li class="nav-item">
                                        <a href="{{ route('admin.treatments') }}" class="nav-link">
                                            <i class="fas fa-hand-holding-medical nav-icon"></i>
                                            <p>{{ __('admin/sidebar.treatments') }}</p>
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </li>
                    @endif
                @endif
                @if (has_permission('admin.users') || has_permission('admin.roles'))
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-users"></i>
                            <p>
                                {{ __('admin/sidebar.users') }}
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            @if (has_permission('admin.roles'))
                                <li class="nav-item">
                                    <a href="{{ route('admin.roles') }}" class="nav-link">
                                        <i class="fas fa-user-tag nav-icon"></i>
                                        <p>{{ __('admin/sidebar.roles') }}</p>
                                    </a>
                                </li>
                            @endif
                            @if (has_permission('admin.users'))
                                <li class="nav-item">
                                    <a href="{{ route('admin.users') }}" class="nav-link">
                                        <i class="fas fa-user nav-icon"></i>
                                        <p>{{ __('admin/sidebar.users') }}</p>
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </li>
                @endif
                @if (has_permission('admin.reviews'))
                    <li class="nav-item">
                        <a href="{{ route('admin.reviews') }}" class="nav-link">
                            <i class="fas fa-star-half-alt nav-icon"></i>
                            <p>{{ __('admin/sidebar.reviews') }}</p>
                        </a>
                    </li>
                @endif
                @if (has_permission('admin.reports.patient_history') || has_permission('admin.reports.booked_appointments') || has_permission('admin.reports.user_activity') || has_permission('admin.reports.appointments'))
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-chart-bar"></i>
                            <p>
                                {{ __('admin/sidebar.title.reports') }}
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            @if (has_permission('admin.reports.patient_history'))
                                <li class="nav-item">
                                    <a href="{{ route('admin.reports.patient_history') }}" class="nav-link">
                                        <i class="fas fa-clipboard-list nav-icon"></i>
                                        <p>{{ __('admin/sidebar.reports.patient_history') }}</p>
                                    </a>
                                </li>
                            @endif
                            @if (has_permission('admin.reports.booked_appointments'))
                                <li class="nav-item">
                                    <a href="{{ route('admin.reports.booked_appointments') }}"
                                        class="nav-link">
                                        <i class="fas far fa-calendar-alt nav-icon"></i>
                                        <p>{{ __('admin/sidebar.reports.booked_appointments') }}</p>
                                    </a>
                                </li>
                            @endif
                            @if (has_permission('admin.reports.appointments'))
                                <li class="nav-item">
                                    <a href="{{ route('admin.reports.appointments') }}"
                                        class="nav-link">
                                        <i class="fas far fa-calendar-alt nav-icon"></i>
                                        <p>{{ __('admin/sidebar.reports.appointments') }}</p>
                                    </a>
                                </li>
                            @endif
                            @if (has_permission('admin.reports.user_activity'))
                                <li class="nav-item">
                                    <a href="{{ route('admin.reports.user_activity') }}"
                                        class="nav-link">
                                        <i class="fas far fa-file-archive nav-icon"></i>
                                        <p>{{ __('admin/sidebar.reports.user_activity') }}</p>
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </li>
                @endif
                @if (has_permission('admin.notifications'))
                    <li class="nav-header text-uppercase">{{ __('admin/sidebar.title.tools') }}</li>
                    @if (has_permission('admin.notifications'))
                        <li class="nav-item">
                            <a href="{{ route('admin.notifications') }}" class="nav-link">
                                <i class="nav-icon far fa-bell"></i>
                                <p>
                                    {{ __('admin/sidebar.notifications') }}
                                </p>
                            </a>
                        </li>
                    @endif
                @endif
                @if (has_permission('admin.regions') || has_permission('admin.social_accounts'))
                    <li class="nav-header text-uppercase">{{ __('admin/sidebar.title.system') }}</li>
                    @if (has_permission('admin.regions'))
                        <li class="nav-item">
                            <a href="{{ route('admin.regions') }}" class="nav-link">
                                <i class="nav-icon fas fa-map-marked"></i>
                                <p>
                                    {{ __('admin/sidebar.regions') }}
                                </p>
                            </a>
                        </li>
                    @endif
                    @if (has_permission('admin.social_accounts'))
                        <li class="nav-item">
                            <a href="{{ route('admin.social_accounts') }}" class="nav-link">
                                <i class="fas fa-share-alt nav-icon"></i>
                                <p>{{ __('admin/sidebar.social_accounts') }}</p>
                            </a>
                        </li>
                    @endif
                    {{-- @if (has_permission('admin.settings'))
                        <li class="nav-item">
                            <a href="{{ route('admin.settings') }}" class="nav-link">
                                <i class="fas fa-cog nav-icon"></i>
                                <p>{{ __('admin/sidebar.settings') }}</p>
                            </a>
                        </li>
                    @endif --}}
                @endif
            </ul>
        </nav>
    </div>
</aside>
