<div class="col-12">
    <form action="{{ route('admin.appointments.update', $appointment->app_id) }}" method="POST"
        enctype="multipart/form-data" id="add-appointment-form" class="p-3 bg-white">
        @csrf
        <div class="form-group row">
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label" for="services">{{ __('admin/appointments.form.patient') }}</label>
                <input class="form-control" value="{{ $appointment->patient_name }}" disabled>
                <input type="hidden" name="patient" id="patient" value="{{ $appointment->patient_id }}">
            </div>
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label" for="branches">{{ __('admin/appointments.form.branch') }}</label>
                <select id="branches" name="branch" class="form-control">
                    @foreach ($branches as $branch)
                        <option value="{{ $branch->id }}"
                            <?= $appointment->branch_id == $branch->id ? 'selected' : '' ?>>{{ $branch->branch }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label" for="treatments">{{ __('admin/appointments.form.treatment') }}</label>
                <select id="treatments" name="treatment" class="form-control">
                    @foreach ($treatments as $treatment)
                        <option value="{{ $treatment->id }}"
                            <?= $appointment->treatment_id == $treatment->id ? 'selected' : '' ?>>
                            {{ $treatment->treatment }}</option>
                    @endforeach
                </select>
            </div>
            <input type="hidden" value="{{ $appointment->app_id }}" name="app-id">
        </div>
        <div id="sessions-table" class="form-group row mt-5">
            {!! $app_table !!}
        </div>
    </form>
    <script>
        $(document).ready(function() {

            $(document).on('change', '#patients', function() {

                let branch = this.value;

                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.appointments.get_branches') }}",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        console.log(XMLHttpRequest.responseText);
                        $('#loading-overlay').removeClass('is-active');
                        $('#branches').attr('disabled');

                    },
                    success: function(data) {
                        let html = '<option value="-1" disabled selected>-- Select --</option>';

                        $.each(data.treatments, function(index, value) {

                            html += '<option value="' + value.id + '">' + value.branch +
                                '</option>'
                        });

                        $('#branches').html(html);

                        $('#branches').removeAttr('disabled');
                        $('#branches').selectpicker('refresh');
                        $('#sessions-table').html('');
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });


            });

            $(document).on('change', '#branches', function() {

                let branch = this.value;

                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.appointments.get_treatments') }}" + '/' + branch,
                    dataType: "json",
                    beforeSend: function() {
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        console.log(XMLHttpRequest.responseText);
                        $('#loading-overlay').removeClass('is-active');
                        $('#treatments').attr('disabled');

                    },
                    success: function(data) {
                        let html = '<option value="-1" disabled selected>-- Select --</option>';

                        $.each(data.treatments, function(index, value) {

                            html += '<option value="' + value.id + '">' + value
                                .treatment + '</option>'
                        });

                        $('#treatments').html(html);

                        $('#treatments').removeAttr('disabled');
                        $('#treatments').selectpicker('refresh');
                        $('#sessions-table').html('');
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });


            });

            $(document).on('change', '#treatments', function() {

                let treatment = this.value;
                let branch = $("#branches option:selected").attr('value');
                let patient = $("#patient").val();

                console.log(patient);

                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.appointments.get_calendar') }}" + '/' + patient + '/' +
                        branch + '/' + treatment + '/0',
                    dataType: "html",
                    cache: false,
                    beforeSend: function() {
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        alert('error');
                        console.log(XMLHttpRequest);
                        $('#loading-overlay').removeClass('is-active');
                    },
                    success: function(data) {
                        $('#sessions-table').html(data);
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });
            });

        });
    </script>
</div>
