<!doctype html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" charset="{{ csrf_token() }}">
    <title>{{ config('app.name') }} | {{ $title }}</title>
    <link rel="stylesheet" href="{{ asset('fonts/roboto/roboto.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.7.0/animate.min.css">
    <link rel="stylesheet" href="{{ asset('admin/css/bootstrap.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ asset('admin/css/login.css') }}">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
</head>
<body class="main-bg">
    <div class="container h-100">
        <div class="row h-100">
            <div class="col-8 col-md-6 col-lg-5 col-xl-4 m-auto">
                <div class="text-c animated fadeIn">
                    <div class="logo-badge text-whitesmoke">
                        <img src="{{ asset(config('admin.site_logo')) }}" alt="{{ config('app.name') }}"
                            class="login-image img-circle img-fluid">
                    </div>
                    <h4 class="text-whitesmoke">{{ $title }}</h4>
                    @if ($errors->any())
                        <div class="col-12">
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                @foreach ($errors->all() as $error)
                                    <span>{{ $error }}</span></br>
                                @endforeach
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                    @endif
                    @if (Session::has('error'))
                        <div class="w-100">
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <span>{{ Session::get('error') }}</span></br>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                        @php session()->pull('error') @endphp
                    @endif
                    @if (Session::has('success'))
                        <div class="w-100">
                            <div class="alert alert-success alert-dismissible fade show text-left" role="alert">
                                <span>{!! Session::get('success') !!}</span></br>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                        @php session()->pull('success') @endphp
                    @endif
                    <div class="container-content">