<div class="col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.branches.update',$branch->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group row mb-3 mb-3">
                <div class="col-12 col-md-6">
                    <label for="edit-branch" class="col-form-label required">{{ __('admin/branches.form.branch') }}</label>
                    <input type="text" name="branch" class="form-control" id="edit-branch" value="{{ old('branch',$branch->branch) }}">
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="edit-region" class="col-form-label required">{{ __('admin/branches.form.region') }}</label>
                    <select id="edit-region" name="region" class="form-control">
                        @foreach ($regions as $region)
                            <option value="{{$region->id}}" @if($region->id == old('region',$branch->region_id)) {{'selected'}} @endif >{{ $region->region }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="edit-phone" class="col-form-label">{{ __('admin/branches.form.phone') }}</label>
                    <input type="text" name="phone" class="form-control" id="edit-phone" value="{{ old('phone',$branch->phone) }}">
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="edit-mobile" class="col-form-label">{{ __('admin/branches.form.mobile') }}</label>
                    <input type="text" name="mobile" class="form-control" id="edit-mobile" value="{{ old('mobile',$branch->mobile) }}">
                </div>
                <div class="col-12 mb-3">
                    <label for="edit-address" class="col-form-label">{{ __('admin/branches.form.address') }}</label>
                    <input type="text" name="address" class="form-control" id="edit-address" value="{{ old('address',$branch->address) }}">
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="edit-start-time" class="col-form-label required">{{ __('admin/branches.form.start_time') }}</label>
                    <input type="time" name="start_time" class="form-control" min="08:00" max="18:00" id="edit-start-time" value="{{ old('start_time',$branch->start_time) }}">
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="edit-end-time" class="col-form-label required">{{ __('admin/branches.form.end_time') }}</label>
                    <input type="time" name="end_time" class="form-control" min="08:00" max="18:00" required id="edit-end-time" value="{{ old('end_time',$branch->end_time) }}">
                </div>
            </div>
            <div class="row">
                <x-admin.form.save-button title="{{ __('admin/branches.btn.save') }}" />
            </div>
        </form>
    </div>
    
</div>