<div class="card text-dark border-0 elevation-0">
    <div class="card-body pt-3">
        <form action="{{ route('admin.patients.info.attachments.add',$patient->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="w-100 form-inline">
                <div class="form-group">
                    <label for="attach-title" class="col-form-label">{{ __('admin/patients_info.attachments.title')}}</label>
                    <input type="text" name="attachment-title" id="attach-title" class="form-control ml-3" value="{{ old('attachment-title') }}">
                </div>
                <div class="form-group ml-5">
                    <label for="patient-attachment" class="col-form-label">
                        {{ __('admin/patients_info.attachments.attachment') }}
                    </label>
                    <div class="input-group ml-3">
                        <div class="custom-file">
                            <input type="file" name="patient-attachment" class="custom-file-input" id="patient-attachment"
                                aria-describedby="patient-attachment">
                            <label class="custom-file-label" for="patient-attachment"></label>
                        </div>
                    </div>
                </div>
                <div class="form-group ml-5">
                    <button type="submit" class="btn btn-primary btn-sm">
                        {{ __('admin/patients_info.attachments.add') }}
                    </button>
                </div>
            </div>
        </form>
        <hr>
        @if ($attachments->count() )
            <table class="table table-bordered table-hover">
                <thead class="bg-light">
                    <tr>
                        <th>{{ __('admin/patients_info.attachments.title') }}</th><th>{{ __('admin/patients_info.attachments.date') }}</th>
                        <th>{{ __('admin/common.cols.actions') }}</th>
                    </tr>
                </thead>
                <tbody class="bg-white">
                    @foreach ($attachments as $attachment)
                        <tr>
                            <td class="pretest-title">
                                {{ $attachment->title }}
                            </td>
                            <td>{{ date('Y-m-d @ h:i A', strtotime($attachment->created_at)) }}</td>
                            <td>
                                <a href="{{ route('admin.patients.info.attachments.download', ['patient' => $patient->id,'attachment_id' => $attachment->id]) }}" class="btn btn-sm btn-info"
                                    target="_blank">
                                    <i class="fas fa-file-download"></i>
                                </a>
                                <button type="button" title="{{ __('admin/common.buttons.delete') }}"  data-href="{{ route('admin.patients.info.attachments.delete', ['patient' => $patient->id,'attachment_id' => $attachment->id]) }}" class="btn btn-danger btn-delete btn-sm mr-2">
                                    <i class="fas fa-times"></i>
                                </button>                                
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <div class="w-100 text-center">
                <span>{{ __('admin/common.msgs.no_results') }}</span>
            </div>
        @endif
    </div>
</div>
