<div class="col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.treatment_categories.save') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-8 col-xxl-6">
                    <label for="add-category" class="col-form-label required">
                        {{ __('admin/treatment_categories.form.name') }}
                    </label>
                    <input type="text" name="category" class="form-control" id="add-category"
                        value="{{ old('category') }}">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-8 col-xxl-6">
                    <label for="description" class="col-form-label">
                        {{ __('admin/treatment_categories.form.description') }}
                    </label>
                    <textarea name="description" class="form-control" id="description" rows="5">{{ old('description') }}</textarea>
                </div>
            </div>
            <div class="form-group row mb-4">
                <div class="col-12 col-lg-6">
                    <label for="add-image" class="col-form-label">
                        {{ __('admin/treatment_categories.form.image') }}
                    </label>
                    <div class="input-group">
                        <div class="custom-file">
                            <input type="file" name="image" class="custom-file-input" id="treatment-categories-image"
                                aria-describedby="treatment-categories-image">
                            <label class="custom-file-label" for="treatment-categories-image">
                                {{ __('admin/common.buttons.browse') }}
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group mt-3">
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="shown" class="custom-control-input" value="1" id="is-shown" @if ( old('shown') ) checked @endif>
                    <label class="custom-control-label" for="is-shown">{{ __('admin/treatment_categories.form.show_on_public')}}</label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-8 col-xxl-6 ml-auto">
                    <x-admin.form.save-button />
                </div>
            </div>
        </form>
    </div>
</div>
