<?php


use App\Http\Controllers\Patient\DashboardController;
use App\Http\Controllers\Patient\AccountController;
use App\Http\Controllers\Patient\AppointmentsController;
use App\Http\Controllers\Patient\ComplaintsController;
use App\Http\Controllers\Patient\PatientAuthController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Website Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
//Route::prefix('/patient')->name('patient')->middleware('patient_auth')->middleware('maint_mode')->group(function(){
Route::prefix('/patient')->name('patient')->middleware('patient_auth')->group(function () {

    /** Patient Routes **/
    Route::get('/', [DashboardController::class, 'index'])->name('.home');
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('.dashboard');

    Route::get('/register', [PatientAuthController::class, 'register'])->name('.register');
    Route::post('/register', [PatientAuthController::class, 'register'])->name('.do_register');

    Route::get('/login', [PatientAuthController::class, 'login'])->name('.login');
    Route::post('/login', [PatientAuthController::class, 'login'])->name('.do_login');

    Route::get('/logout', [PatientAuthController::class, 'logout'])->name('.logout');

    Route::get('/verify', [PatientAuthController::class, 'verify'])->name('.verify');
    Route::post('/verify', [PatientAuthController::class, 'verify'])->name('.do_verify');

    Route::get('/forgot', [PatientAuthController::class, 'forgot'])->name('.forgot');
    Route::post('/forgot', [PatientAuthController::class, 'forgot'])->name('.do_forgot');

    /** Account **/
    Route::get('/account', [AccountController::class, 'index'])->name('.account');

    /** Appointments **/
    Route::prefix('/appointments')->name('.appointments')->group(function () {
        Route::get('/', [AppointmentsController::class, 'index'])->name('');
        Route::get('/add', [AppointmentsController::class, 'add'])->name('.add');
        Route::post('/add', [AppointmentsController::class, 'add'])->name('.save');

        Route::get('/get-branches', [AppointmentsController::class, 'getBranches'])->name('.get_branches');
        Route::get('/get-treatments/{branch_id?}', [AppointmentsController::class, 'getTreatments'])->name('.get_treatments');
        Route::get('/get-calendar/{patient_id?}/{branch_id?}/{treatment_id?}/{week_number?}', [AppointmentsController::class, 'getCalendar'])->name('.get_calendar');

        Route::get('/edit/{appointment:id}', [AppointmentsController::class, 'edit'])->name('.edit');
        Route::post('/edit/{appointment:id}', [AppointmentsController::class, 'edit'])->name('.update');

        Route::get('/info/{appointment:id}', [AppointmentsController::class,'info'])->name('.info');

        Route::get('/delete/{appointment_id?}', [AppointmentsController::class,'delete'])->name('.delete');

    });

    /** Complaints **/
    Route::get('/complaints', [ComplaintsController::class, 'index'])->name('.complaints');
    Route::get('/complaints/add', [ComplaintsController::class, 'add'])->name('.complaints.add');
    Route::post('/complaints/add', [ComplaintsController::class, 'add'])->name('.complaints.save');

    Route::get('/complaints/download/{complaint:id}', [ComplaintsController::class,'downloadAttachment'])->name('.complaints.download');
});
