<div class="col-12">
    <div class="card bg-white p-3">
        <form action="<?php echo e(route('admin.patients.save')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col">
                    <h4><?php echo e(__('admin/patients.form.patient_info')); ?></h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-6 col-lg-3">
                    <label for="add-first-name"
                        class="col-form-label required"><?php echo e(__('admin/patients.form.first_name')); ?></label>
                    <input type="text" name="first-name" class="form-control" id="add-first-name"
                        value="<?php echo e(old('first-name')); ?>">
                </div>
                <div class="col-12 col-md-6 col-lg-3">
                    <label for="add-second-name"
                        class="col-form-label"><?php echo e(__('admin/patients.form.second_name')); ?></label>
                    <input type="text" name="second-name" class="form-control" id="add-second-name"
                        value="<?php echo e(old('second-name')); ?>">
                </div>
                <div class="col-12 col-md-6 col-lg-3">
                    <label for="add-third-name"
                        class="col-form-label"><?php echo e(__('admin/patients.form.third_name')); ?></label>
                    <input type="text" name="third-name" class="form-control" id="add-third-name"
                        value="<?php echo e(old('third-name')); ?>">
                </div>
                <div class="col-12 col-md-6 col-lg-3">
                    <label for="add-last-name"
                        class="col-form-label required"><?php echo e(__('admin/patients.form.last_name')); ?></label>
                    <input type="text" name="last-name" class="form-control" id="add-last-name"
                        value="<?php echo e(old('last-name')); ?>">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                    <label for="add-dob" class="col-form-label required"><?php echo e(__('admin/patients.form.dob')); ?></label>
                    <div class="input-group date" id="add-dob" data-target-input="nearest">
                        <input type="text" name="dob" class="form-control datetimepicker-input"
                            data-target="#add-dob" value="<?php echo e(old('dob')); ?>">
                        <div class="input-group-append" data-target="#add-dob" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                    <label for="add-gender" class="col-form-label required">
                        <?php echo e(__('admin/patients.form.gender')); ?>

                    </label>
                    <select name="gender" class="form-control" id="add-gender">
                        <option value="m" <?php echo e(old('gender') == 'm' ? 'selected' : ''); ?>>
                            <?php echo e(__('admin/common.gender.male')); ?>

                        </option>
                        <option value="f" <?php echo e(old('gender') == 'f' ? 'selected' : ''); ?>>
                            <?php echo e(__('admin/common.gender.female')); ?>

                        </option>
                    </select>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                    <label for="add-mobile" class="col-form-label required">
                        <?php echo e(__('admin/patients.form.mobile')); ?>

                        <small class="muted">(05xxxxxxx)</small>
                    </label>
                    <input type="text" name="mobile" class="form-control" id="add-mobile"
                        value="<?php echo e(old('mobile')); ?>">
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                    <label for="add-email"
                        class="col-form-label"><?php echo e(__('admin/patients.form.email')); ?></label>
                    <input type="text" name="email" class="form-control" id="add-email" value="<?php echo e(old('email')); ?>">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6 py-0">
                    <div class="w-100 mb-3">
                        <label for="add-region"
                            class="col-form-label required"><?php echo e(__('admin/patients.form.region')); ?></label>
                        <select name="region" class="form-control" id="add-region">
                            <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($region->id); ?>"
                                    <?php echo e(old('region') == $region->id ? 'selected' : ''); ?>><?php echo e($region->region); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="w-100">
                        <label for="add-address" class="col-form-label">
                            <?php echo e(__('admin/patients.form.address')); ?>

                        </label>
                        <input type="text" name="address" class="form-control" id="add-address"
                            value="<?php echo e(old('address')); ?>">
                    </div>
                </div>
                <div class="col-12 col-lg-6">
                    <div class="w-100">
                        <label for="add-comment" class="col-form-label">
                            <?php echo e(__('admin/patients.form.comment')); ?>

                        </label>
                        <textarea name="comment" class="form-control" rows="5"
                            id="add-comment"><?php echo e(old('comment')); ?></textarea>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col">
                    <h4><?php echo e(__('admin/patients.form.account_info')); ?></h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="add-password" class="col-form-label required">
                        <?php echo e(__('admin/patients.form.password')); ?>

                        <small class="muted"><?php echo e(__('admin/patients.form.min_chars')); ?></small>
                    </label>
                    <input type="text" name="password" class="form-control" id="add-password" value="12345678">
                    <label id="pass-suggestion" class="mt-3 text-info">
                        <?php echo e(__('admin/patients.form.suggestion')); ?>

                        <span class="bg-light"><?php echo e($gen_password); ?></span>
                    </label>
                </div>
                <div class="col-6">
                    <label for="add-cpassword"
                        class="col-form-label required"><?php echo e(__('admin/patients.form.cpassword')); ?></label>
                    <input type="text" name="cpassword" class="form-control" id="add-cpassword" value="12345678">
                </div>
            </div>
            <div class="form-group">
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="blocked" class="custom-control-input" value="1" id="is-blocked">
                    <label class="custom-control-label"
                        for="is-blocked"><?php echo e(__('admin/patients.form.is_blocked')); ?></label>
                </div>
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="notify" class="custom-control-input" value="1" id="notify">
                    <label class="custom-control-label" for="notify">
                        <?php echo e(__('admin/patients.form.notify')); ?>

                    </label>
                </div>
            </div>
            <div class="form-group row">
                <?php if (isset($component)) { $__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Admin\Form\SaveButton::class, []); ?>
<?php $component->withName('admin.form.save-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['title' => ''.e(__('admin/common.btn.save')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477)): ?>
<?php $component = $__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477; ?>
<?php unset($__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477); ?>
<?php endif; ?>
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {

            $('#pass-suggestion').on('click', function() {

                let pass = $('#pass-suggestion > span').html();

                $('#add-password').val(pass);
                $('#add-cpassword').val(pass);

            });

            var start_date = moment().subtract(70, "years").format("YYYY-MM-DD");
            var default_date = moment().subtract(25, "years").format("YYYY-MM-DD");
           

            $('#add-dob').datepicker({
                format: 'yyyy-mm-dd',
                endDate: '0d',
                startdate: start_date,
                defaultViewDate: default_date,
            });
        });
    </script>
</div>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/patients/add.blade.php ENDPATH**/ ?>