<aside class="main-sidebar sidebar-dark-primary">
    <?php if(config('admin.site_logo')): ?>
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="brand-link text-left">
            <img src="<?php echo e(asset(config('admin.site_logo'))); ?>" alt="<?php echo e(config('app.name')); ?>"
                class="brand-image img-circle elevation-3" style="opacity: .8">
            <span class="brand-text font-weight-light"><?php echo e(config('app.name')); ?></span>
        </a>
        
    <?php else: ?>
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="brand-link text-center">
            <span class="brand-text font-weight-light"><?php echo e(config('app.name')); ?></span>
        </a>
    <?php endif; ?>
    <div class="sidebar pb-5">
        <?php if(user_id()): ?>
            <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                <div class="info text-white">
                    <span class="text-sm text-light">
                        <?php echo e(__('admin/common.text.welcome')); ?>,
                        <?php echo e(user_name()); ?>

                    </span><br>
                    <a href="<?php echo e(route('admin.auth.logout')); ?>" class="text-sm">
                        <?php echo e(__('admin/auth.logout')); ?>

                    </a>
                </div>
            </div>
        <?php endif; ?>
        <div class="form-inline">
            <div class="input-group input-group-sm" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar" type="search" placeholder="Search" aria-label="Search">
                <div class="input-group-append">
                    <button class="btn btn-sidebar">
                        <i class="fas fa-search fa-fw"></i>
                    </button>
                </div>
            </div>
        </div>
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column nav-collapse-hide-child nav-child-indent nav-flat <?php if(app()->getLocale() == 'en'): ?> text-sm <?php endif; ?>"
                data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="nav-link">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                            <?php echo e(__('admin/sidebar.dashboard')); ?>

                        </p>
                    </a>
                </li>
                <?php if(has_permission('admin.appointments') || has_permission('admin.patients') || has_permission('admin.pretests') || has_permission('admin.complaints') || has_permission('admin.offers')): ?>
                    <li class="nav-header text-uppercase"><?php echo e(__('admin/sidebar.title.patients')); ?></li>
                    <?php if(has_permission('admin.appointments')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.appointments')); ?>" class="nav-link">
                                <i class="nav-icon far fa-calendar-alt"></i>
                                <p>
                                    <?php echo e(__('admin/sidebar.appointments')); ?>

                                </p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(has_permission('admin.patients')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.patients')); ?>" class="nav-link">
                                <i class="nav-icon fas fa-procedures"></i>
                                <p>
                                    <?php echo e(__('admin/sidebar.patients')); ?>

                                </p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(has_permission('admin.pretests')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.pretests')); ?>" class="nav-link">
                                <i class="nav-icon fas fa-stethoscope"></i>
                                <p>
                                    <?php echo e(__('admin/sidebar.pretests')); ?>

                                </p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(has_permission('admin.complaints')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.complaints')); ?>" class="nav-link">
                                <i class="nav-icon fas fa-comment-medical"></i>
                                <p>
                                    <?php echo e(__('admin/sidebar.complaints')); ?>

                                </p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(has_permission('admin.offers')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.offers')); ?>" class="nav-link">
                                <i class="nav-icon fas fa-gift"></i>
                                <p>
                                    <?php echo e(__('admin/sidebar.offers')); ?>

                                </p>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if(has_permission('admin.treatments') || has_permission('admin.treatment_categories') || has_permission('admin.branches') || has_permission('admin.regions') || has_permission('admin.roles') || has_permission('admin.users') || has_permission('admin.reviews')): ?>
                    <!-- Center Management -->
                    <li class="nav-header text-uppercase"><?php echo e(__('admin/sidebar.title.center')); ?></li>
                    <?php if(has_permission('admin.branches')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.branches')); ?>" class="nav-link">
                                <i class="nav-icon fas fa-hospital"></i>
                                <p>
                                    <?php echo e(__('admin/sidebar.branches')); ?>

                                </p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(has_permission('admin.treatments') || has_permission('admin.treatment_categories')): ?>
                        <li class="nav-item">
                            <a href="#" class="nav-link">
                                <i class="nav-icon fas fa-hand-holding-medical"></i>
                                <p><?php echo e(__('admin/sidebar.treatments')); ?><i class="right fas fa-angle-left"></i></p>
                            </a>
                            <ul class="nav nav-treeview">
                                <?php if(has_permission('admin.treatment_categories')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('admin.treatment_categories')); ?>" class="nav-link">
                                            <i class="fas fa-folder-plus nav-icon"></i>
                                            <p><?php echo e(__('admin/sidebar.treatment_categories')); ?></p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if(has_permission('admin.treatments')): ?>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('admin.treatments')); ?>" class="nav-link">
                                            <i class="fas fa-hand-holding-medical nav-icon"></i>
                                            <p><?php echo e(__('admin/sidebar.treatments')); ?></p>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if(has_permission('admin.users') || has_permission('admin.roles')): ?>
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-users"></i>
                            <p>
                                <?php echo e(__('admin/sidebar.users')); ?>

                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <?php if(has_permission('admin.roles')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('admin.roles')); ?>" class="nav-link">
                                        <i class="fas fa-user-tag nav-icon"></i>
                                        <p><?php echo e(__('admin/sidebar.roles')); ?></p>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission('admin.users')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('admin.users')); ?>" class="nav-link">
                                        <i class="fas fa-user nav-icon"></i>
                                        <p><?php echo e(__('admin/sidebar.users')); ?></p>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>
                <?php if(has_permission('admin.reviews')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('admin.reviews')); ?>" class="nav-link">
                            <i class="fas fa-star-half-alt nav-icon"></i>
                            <p><?php echo e(__('admin/sidebar.reviews')); ?></p>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if(has_permission('admin.reports.patient_history') || has_permission('admin.reports.booked_appointments') || has_permission('admin.reports.user_activity') || has_permission('admin.reports.appointments')): ?>
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-chart-bar"></i>
                            <p>
                                <?php echo e(__('admin/sidebar.title.reports')); ?>

                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <?php if(has_permission('admin.reports.patient_history')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('admin.reports.patient_history')); ?>" class="nav-link">
                                        <i class="fas fa-clipboard-list nav-icon"></i>
                                        <p><?php echo e(__('admin/sidebar.reports.patient_history')); ?></p>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission('admin.reports.booked_appointments')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('admin.reports.booked_appointments')); ?>"
                                        class="nav-link">
                                        <i class="fas far fa-calendar-alt nav-icon"></i>
                                        <p><?php echo e(__('admin/sidebar.reports.booked_appointments')); ?></p>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission('admin.reports.appointments')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('admin.reports.appointments')); ?>"
                                        class="nav-link">
                                        <i class="fas far fa-calendar-alt nav-icon"></i>
                                        <p><?php echo e(__('admin/sidebar.reports.appointments')); ?></p>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(has_permission('admin.reports.user_activity')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('admin.reports.user_activity')); ?>"
                                        class="nav-link">
                                        <i class="fas far fa-file-archive nav-icon"></i>
                                        <p><?php echo e(__('admin/sidebar.reports.user_activity')); ?></p>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>
                <?php if(has_permission('admin.notifications')): ?>
                    <li class="nav-header text-uppercase"><?php echo e(__('admin/sidebar.title.tools')); ?></li>
                    <?php if(has_permission('admin.notifications')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.notifications')); ?>" class="nav-link">
                                <i class="nav-icon far fa-bell"></i>
                                <p>
                                    <?php echo e(__('admin/sidebar.notifications')); ?>

                                </p>
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if(has_permission('admin.regions') || has_permission('admin.social_accounts')): ?>
                    <li class="nav-header text-uppercase"><?php echo e(__('admin/sidebar.title.system')); ?></li>
                    <?php if(has_permission('admin.regions')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.regions')); ?>" class="nav-link">
                                <i class="nav-icon fas fa-map-marked"></i>
                                <p>
                                    <?php echo e(__('admin/sidebar.regions')); ?>

                                </p>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(has_permission('admin.social_accounts')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.social_accounts')); ?>" class="nav-link">
                                <i class="fas fa-share-alt nav-icon"></i>
                                <p><?php echo e(__('admin/sidebar.social_accounts')); ?></p>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                <?php endif; ?>
            </ul>
        </nav>
    </div>
</aside>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/app/sidebar.blade.php ENDPATH**/ ?>