<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
    </ul>
    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="fas fa-globe"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <a href="<?php echo e(route('admin.set_locale') . '?lang=ar'); ?>" class="dropdown-item">
                    العربية
                </a>
                <a href="<?php echo e(route('admin.set_locale') . '?lang=en'); ?>" class="dropdown-item">
                    English
                </a>
            </div>
        </li>
        <li id="notifications" class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="far fa-bell"></i>
                <span
                    class="badge badge-warning navbar-badge notif-count <?php if($_notifications_count == 0): ?> d-none <?php endif; ?>"><?php echo e($_notifications_count); ?></span>
            </a>
            <div id="notifications-dropdown" class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <?php $__currentLoopData = $_notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php if($notification->link): ?> <?php echo e($notification->link); ?> <?php else: ?> # <?php endif; ?>" data-id="<?php echo e($notification->id); ?>"
                        class="dropdown-item py-1 notification px-0 border-bottom">
                        <div class="<?php if($notification->read_at == null): ?>callout callout-warning <?php endif; ?> mb-0 bg-transparent px-3 elevation-0 rounded-0 py-1">
                            <div class="d-flex">
                                <span class="h6"><?php echo e($notification->title); ?></span>
                                
                            </div>
                            <p class="text-sm">
                                <?php echo e(\Illuminate\Support\Str::limit($notification->body, 150, $end = '...')); ?>

                            </p>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div class="dropdown-divider"></div>
                <a href="#" class="dropdown-item dropdown-footer">See All Notifications</a>
            </div>
        </li>
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="fas fa-user-circle"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <a href="<?php echo e(route('admin.profile')); ?>" class="dropdown-item">
                    <?php echo e(__('admin/profile.title')); ?>

                </a>
                <a href="<?php echo e(route('admin.auth.logout')); ?>" class="dropdown-item">
                    <?php echo e(__('admin/auth.logout')); ?>

                </a>
            </div>
        </li>
    </ul>
    <script>
        $(document).ready(function() {

            setInterval(getNotifications, 5000);

            $(document).on('click', '#notifications-dropdown .notification', function(e) {

                e.preventDefault();

                let id = $(this).data('id');

                let href = $(this).attr('href');

                $.ajax({
                    url: "<?php echo e(route('admin.dashboard.mark_as_read')); ?>" + "/" + id,
                    type: 'GET',
                    success: function() {
                        getNotifications();
                        window.location.href = href;
                    }
                });

                return false;


            });
        });

        function diff_minutes(dt2, dt1) {
            var diff = (dt2.getTime() - dt1.getTime()) / 1000;
            diff /= 60;

            let diff_in_minutes = Math.abs(Math.round(diff))

            let result = diff_in_minutes;

            if (diff_in_minutes <= 59) {
                return result +" <?php echo e(__('admin/common.text.minutes')); ?>";
            }

            if (diff_in_minutes > 59 && diff_in_minutes <= 1439) {
                result /= 60
                return Math.abs(Math.round(result)) + " <?php echo e(__('admin/common.text.hours')); ?>";
            }

            if (diff_in_minutes > 1440) {
                result /= (60 * 24)
                return Math.abs(Math.round(result)) + " <?php echo e(__('admin/common.text.days')); ?>";
            }


            return result;
        }

        function getNotifications() {

            $.ajax({
                url: "<?php echo e(route('admin.dashboard.get_notifications')); ?>",
                type: 'GET',
                dataType: 'json',
                success: function(response) {

                    let count = response.count;

                    $('#notifications .notif-count').html(count);

                    if (count > 0) {
                        $('#notifications .notif-count').removeClass('d-none');
                    }


                    let html = '';

                    $(response.notifications).each(function(index, notif) {

                        if (notif.link == null) {
                            html +=
                                '<a href="#" class="dropdown-item py-1 px-0 border-bottom notification" data-id="' +
                                notif.id + '">';
                        } else {
                            html += '<a href="' + notif.link +
                                '" class="dropdown-item py-1 px-0 border-bottom" data-id="' + notif.id +
                                '">';
                        }

                        if (notif.read_at == null) {
                            html +=
                                ' <div class="callout callout-warning mb-0 bg-transparent px-3 elevation-0 rounded-0 py-1">';
                        } else {
                            html +=
                                ' <div class="mb-0 bg-transparent px-3 elevation-0 rounded-0 py-1">';
                        }

                        html += '<div class="d-flex">';
                        html += '<span class="h6">' + notif.title + '</span>';

                        dt1 = new Date(notif.sent_at);
                        dt2 = new Date();
                        let time = diff_minutes(dt1, dt2);
                        html += '<span class="ml-auto text-muted text-sm">' + time + '</span>';
                        html += '</div>';
                        html += '<p class="text-sm">';
                        if (notif.body.length > 100) {
                            html += notif.body.substring(0, 100) + '...';
                        } else {
                            html += notif.body;
                        }
                        html += ' </p>';
                        html += ' </div>';
                        html += '</a>';
                    });

                    html += '<div class="dropdown-divider"></div>';
                    html += '<a href="#" class="dropdown-item dropdown-footer">See All Notifications</a>';

                    $('#notifications-dropdown').html(html);
                }
            });
        }
    </script>
</nav>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/app/navbar.blade.php ENDPATH**/ ?>