<div class="container">
    <div class="row">
        <div class="col-12 mx-auto mt-5">
            <div class="alert alert-info" role="alert">
                سوف يتم ارسال رمز تحقق إلى رقم الموبايل لذا نرجو التأكد من ادخال الرقم الصحيح لتتمكن من تسجيل الدخول
                لاحقا
            </div>
            <form action="<?php echo e(route('patient.register')); ?>" method="POST" id="register-form"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <span class="h3 text-gold-light fw-light mb-5"><?php echo e(__('patient/register.form.title')); ?></span>
                <div class="form-group mt-3">
                    <span><?php echo e(__('patient/register.form.member')); ?></span>
                    <a href="<?php echo e(route('patient.login')); ?>" class="text-gold-light">
                        <?php echo e(__('patient/register.form.login')); ?>

                    </a>
                </div>
                <div class="mt-5 mb-3 row">
                    <div class="col-12 mb-3">
                        <span class="fs-5 fw-light text-gold-light"><?php echo e(__('patient/register.form.full_name')); ?></span>
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 mb-3">
                        <label for="first-name" class="form-label required">
                            <?php echo e(__('patient/register.form.first_name')); ?>

                        </label>
                        <input type="text" name="first-name" class="form-control" id="first-name"
                            value="<?php echo e(old('first-name')); ?>">
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 mb-3">
                        <label for="last-name" class="form-label required">
                            <?php echo e(__('patient/register.form.last_name')); ?>

                        </label>
                        <input type="text" name="last-name" class="form-control" id="last-name"
                            value="<?php echo e(old('last-name')); ?>">
                    </div>
                </div>
                <div class="mb-3 row">
                    <div class="col-12 mb-3">
                        <span class="fs-5 fw-light text-gold-light">
                            <?php echo e(__('patient/register.form.contact_info')); ?>

                        </span>
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 mb-3">
                        <label for="mobile"
                            class="form-label required"><?php echo e(__('patient/register.form.mobile')); ?></label>
                        <input type="text" name="mobile" class="form-control" id="mobile"
                            value="<?php echo e(old('mobile')); ?>">
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 mb-3">
                        <label for="region" class="form-label required">
                            <?php echo e(__('patient/register.form.region')); ?>

                        </label>
                        <select name="region" id="region" class="form-select">
                            <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($region->id); ?>"><?php echo e($region->region); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="mb-3 row">
                    <div class="col-12 mb-3">
                        <span class="fs-5 fw-light text-gold-light">
                            <?php echo e(__('patient/register.form.dob_title')); ?>

                        </span>
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 mb-3">
                        <label for="dob" class="form-label required"><?php echo e(__('patient/register.form.dob')); ?></label>
                        <div class="input-group mb-3">
                            <input type="text" name="dob" id="dob" class="form-control" placeholder="Year-Month-Day"
                                aria-label="YYYY-MM-DD" aria-describedby="dob-addon" value="<?php echo e(old('dob')); ?>">
                            <span class="input-group-text" id="dob-addon">
                                <i class="fas fa-calendar"></i>
                            </span>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 mb-3">
                        <label for="gender" class="form-label required">
                            <?php echo e(__('patient/register.form.gender')); ?>

                        </label>
                        <select name="gender" id="gender" class="form-select">
                            <option value="f" <?php if(old('gender') == 'f'): ?> selected <?php endif; ?>>
                                <?php echo e(__('patient/common.gender.female')); ?></option>
                            <option value="m" <?php if(old('gender') == 'm'): ?> selected <?php endif; ?>><?php echo e(__('patient/common.gender.male')); ?>

                            </option>
                        </select>
                    </div>
                </div>
                <div class="mb-3 row">
                    <div class="col-12 mb-3">
                        <span
                            class="fs-5 fw-light text-gold-light"><?php echo e(__('patient/register.form.account_info')); ?></span>
                    </div>
                    <div class="col-12 col-md-6 col-lg-4 mb-3">
                        <label for="password" class="form-label required">
                            <?php echo e(__('patient/register.form.password')); ?>

                        </label>
                        <div class="input-group mb-3">
                            <input type="password" name="password" id="password" class="form-control"
                                data-visibile="false" aria-describedby="toggle-password">
                            <button class="btn btn-light" type="button" id="toggle-password">
                                <i class="far fa-eye-slash"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="mb-3 row">
                    <div class="col-12">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" value="1" name="credibility"
                                id="credibility">
                            <label class="form-check-label" for="credibility">
                                <?php echo e(__('patient/register.form.credibility')); ?>

                            </label>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-gold mt-4">
                    <?php echo e(__('patient/register.form.register')); ?>

                </button>
                <!--<div class="text-center mt-4">
                    <p class="">or sign up with</p>
                    <a type="button" class="btn btn-gold btn-floating mx-1">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a type="button" class="btn btn-gold btn-floating mx-1">
                        <i class="fab fa-google"></i>
                    </a>
                </div>-->
            </form>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            var start_date = moment().subtract(70, "years").format("YYYY-MM-DD");
            var default_date = moment().subtract(25, "years").format("YYYY-MM-DD");

            $('#dob').datepicker({
                format: 'yyyy-mm-dd',
                endDate: '0d',
                startdate: start_date,
                defaultViewDate: default_date,
            });

            $('#toggle-password').on('click', function(e) {

                e.preventDefault();

                let pass_field = $('#password');

                if (pass_field.data('visibile') == 'true') {
                    pass_field.data('visibile', 'false');
                    pass_field.attr('type', 'password');
                    $(this).html('<i class="far fa-eye-slash"></i>');
                } else {
                    pass_field.data('visibile', 'true');
                    pass_field.attr('type', 'text');
                    $(this).html('<i class="far fa-eye"></i>');

                }

            });
        });
    </script>
</div>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/patient/register.blade.php ENDPATH**/ ?>