<!doctype html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" charset="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name')); ?> | <?php echo e($title); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('fonts/roboto/roboto.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.7.0/animate.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/bootstrap.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('admin/css/login.css')); ?>">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
</head>
<body class="main-bg">
    <div class="container h-100">
        <div class="row h-100">
            <div class="col-8 col-md-6 col-lg-5 col-xl-4 m-auto">
                <div class="text-c animated fadeIn">
                    <div class="logo-badge text-whitesmoke">
                        <img src="<?php echo e(asset(config('admin.site_logo'))); ?>" alt="<?php echo e(config('app.name')); ?>"
                            class="login-image img-circle img-fluid">
                    </div>
                    <h4 class="text-whitesmoke"><?php echo e($title); ?></h4>
                    <?php if($errors->any()): ?>
                        <div class="col-12">
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span><?php echo e($error); ?></span></br>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(Session::has('error')): ?>
                        <div class="w-100">
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <span><?php echo e(Session::get('error')); ?></span></br>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                        <?php session()->pull('error') ?>
                    <?php endif; ?>
                    <?php if(Session::has('success')): ?>
                        <div class="w-100">
                            <div class="alert alert-success alert-dismissible fade show text-left" role="alert">
                                <span><?php echo Session::get('success'); ?></span></br>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                        <?php session()->pull('success') ?>
                    <?php endif; ?>
                    <div class="container-content"><?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/auth/header.blade.php ENDPATH**/ ?>